package com.titan.clients;

import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.persistence.Persistence;

import com.titan.domain.*;

public class Client1
{
   public static void main(String[] args) throws Exception 
   {
      EntityManagerFactory factory =
         Persistence.createEntityManagerFactory("titan");
      try 
      {
         Customer cust = createCustomerAddress(factory);
         cascadeMergeAddress(factory, cust);
         cascadeRemoveAddress(factory, cust);
      } 
      finally 
      {
         factory.close();
      }
   }

   public static Customer createCustomerAddress(EntityManagerFactory factory)
   {
      System.out.println("Tworzy pierwsz encj Customer");
      Customer cust = new Customer();
      cust.setFirstName("Bartosz");
      cust.setLastName("Biernacki");
      Address address = new Address();
      address.setStreet("ul. Bekonowa");
      address.setCity("Bytom");
      address.setState("lskie");
      address.setZip("42-054");
      cust.setAddress(address);
      EntityManager manager = factory.createEntityManager();
      try
      {
         manager.getTransaction().begin();
         manager.persist(cust);
         manager.getTransaction().commit();
      }
      finally
      {
         manager.close();
      }
      System.out.println("Encja Address zostaa utrwalona z automatycznie wygenerowanym kluczem: " 
                         + address.getId());
      System.out.println("Zwracamy odczony egzemplarz encji Customer: " + cust.getId());
      return cust;
   }

   public static void cascadeMergeAddress(EntityManagerFactory factory, Customer cust)
   {
      System.out.println("Prezentacja propagacji kaskadowej wywoania metody merge().");
      cust.getAddress().setStreet("al. Lipowa 1");

      EntityManager manager = factory.createEntityManager();
      try
      {
         manager.getTransaction().begin();
         manager.merge(cust);
         manager.getTransaction().commit();

         manager.clear();
         Customer custCopy = manager.find(Customer.class, cust.getId());
         System.out.println(custCopy.getAddress().getStreet());
      }
      finally
      {
         manager.close();
      }
   }

   public static void cascadeRemoveAddress(EntityManagerFactory factory, Customer cust)
   {
      System.out.println("Prezentacja propagacji kaskadowej wywoania metody remove().");
      EntityManager manager = factory.createEntityManager();

      try
      {
         manager.getTransaction().begin();
         Customer custCopy = manager.find(Customer.class, cust.getId());
         manager.remove(custCopy);
         manager.getTransaction().commit();
         
         Address addressCopy = manager.find(Address.class, cust.getAddress().getId());
         System.out.println("addressCopy ma warto null: " + addressCopy);
      }
      finally
      {
         manager.close();
      }
   }
}
