import javax.naming.*;

/**
 * Klasa pomocnicza uruchamiajaca nasz serwer RMI-IIOP
 */
public class Start {

  /**
   * Nasza metoda main() uruchamia wszyskie mechanizmy
   */  
  public static void main(String args[]) throws Exception {

    /*
     * Uruchomienie zdalnego obiektu GeneratorKG. Jest on 
     * automatycznie eksportowany.
     */
    GeneratorKG generator = new GeneratorKG();

    /*
     * Dolaczanie zdalnego obiektu GeneratorKG do drzewa JNDI
     */
    Context ctx = new InitialContext(System.getProperties());
    ctx.rebind("GeneratorKG", generator);
    System.out.println("GeneratorKG dowizany do drzewa JNDI.");

    synchronized (generator) {
      generator.wait();
    }
  }  
}
