package przyklady;

import javax.ejb.*;
import java.util.Collection;

/**
 * To jest lokalny interfejs domowy komponentu Konto.
 * Interfejs jest implementowany przez narzedzia
 * serwera EJB  zaimplementowany obiekt, ktory
 * nazywany lokalnym obiektem domowym, umozliwia 
 * klientom dostep do lokalnych obiektow EJB.
 */
public interface KontoLokalnyDomowy extends EJBLocalHome {

  /**
   * Definiujemy w tym interfejsie domowym pojedyncza metode create(),
   * ktora odpowiada metodzie ejbCreate() klasy KontoKomponent.
   * Metoda tworzy lokalny obiekt EJB.
   *
   * Zauwaz, ze lokalny interfejs domowy zwraca interfejs lokalny,
   * w ktorym komponent zwraca klucz glowny.
   *
   * Zauwaz, ze nie generujemy wyjatkow RemoteException, poniewaz dzialamy lokalnie.
   *
   * @param identyfikatorKonta Unikalny numer konta
   * @param nazwiskoWlasciciela Nazwisko osoby posiadajacej to konto
   * @return Nowo stworzony obiekt lokalny.
   */
  KontoLokalny create(String identyfikatorKonta, String nazwiskoWlasciciela) throws CreateException;

  /**
   * Znajduje konto na podstawie jego klucza glownego (identyfikatora)
   */
  public KontoLokalny findByPrimaryKey(KontoKG klucz) throws FinderException;

  /**
     * Znajduje wszystkie konta posiadane przez dana osobe
   */
  public Collection findDlaNazwiskaWlasciciela(String nazwisko) throws FinderException;

  /**
   * To jest domowa metoda biznesowa niezalezna od danych konkretnego konta
   * Zwraca laczna ilosc srodkow na wszyskich kontach w naszym banku.
   */
  public double getLacznaWartoscKont() throws KontoException;

}

