package przyklady;

import javax.ejb.*;
import javax.naming.*;
import java.rmi.*;
import javax.rmi.*;
import java.util.*;

/**
 * Przykladowy kod klienta operujacego na komponencie encyjnym
 * reprezentujacym konto bankowe.
 */
public class KontoKlient {

  public static void main(String[] args) throws Exception {

    Konto konto = null;

    try {
      /*
       * Pobiera odwolanie do obiektu domowego komponentu Konto,
       * ktory umozliwia kontakt z obiektami EJB
       */
      Context kontekst = new InitialContext(System.getProperties());
      
      Object ob = kontekst.lookup("KontoDomowy");
      KontoDomowy domowy = (KontoDomowy) javax.rmi.PortableRemoteObject.narrow(ob,
KontoDomowy.class);

      System.err.println("Poczatkowa laczna wartosc kont bankowych = " + domowy.getLacznaWartoscKont());

      /*
       * Wykorzystuje obiekt domowy do stworzenia obiektu EJB komponentu Konto
       */
      domowy.create("123-456-7890", "Jan Kowalski");

      /*
       * Znajduje konto
       */
      Iterator i = domowy.findDlaNazwiskaWlasciciela("Jan Kowalski").iterator();
      if (i.hasNext()) {
        konto = (Konto) 
          javax.rmi.PortableRemoteObject.narrow(
            i.next(), Konto.class);

      }
      else {
        throw new Exception("Nie mozna znalezc konta");
      }

      /*
       * Wywoluje metode getSaldo() i wyswietla otrzymany wynik
       */
      System.out.println("Saldo poczatkowe = " + konto.getSaldo());

      /*
       * Wplaca 100 zlotych na konto
       */
      konto.wplac(100);

      /*
       * Sprawdza saldo po wplacie.
       */
      System.out.println("Po wplaceniu 100 zlotych, saldo konta = " + konto.getSaldo());

      System.out.println("Aktualna laczna wartosc kont bankowych = " +
domowy. getLacznaWartoscKont());

      /*
       * Pobiera klucz glowny z obiektu EJB
       */
      KontoKG kg = (KontoKG) konto.getPrimaryKey();

      /*
       * Zwalnia odwolanie do starego obiektu EJB. Wywoluje teraz ponownie
       * metode wyszukujaca, tym razem podajac identyfikator konta
       * (czyli otrzymany przed momentem z obiektu EJB klucz glowny).
       */
      konto = null;
      konto = domowy.findByPrimaryKey(kg);

      /*
       * Wyswietla aktualne saldo
       */
      System.out.println("Znaleziono konto o identyfikatorze " + kg + ". Saldo konta = " + konto.getSaldo());

      /*
       * Probuje wyplacic 150 zlotych
       */
      System.out.println("Proba wyplacenia 150 zlotych, czyli kwoty przekraczajacej aktualne saldo konta. Taka operacja powinna spowodowac wygenerowanie wyjatku...");
      konto.wyplac(150);

    }
    catch (Exception e) {
      System.out.println("Wygenerowano wyjatek!");
      e.printStackTrace();
    }
    finally {
      /*
       * Trwale usuwa encje
       */
      try {
        System.out.println("Usuwanie konta..");
        if (konto != null) {
          konto.remove();
        }
      }
      catch (Exception e) {
        e.printStackTrace();
      }
    }
  }
}

