package przyklady;

import javax.ejb.*;
import java.rmi.RemoteException;

/**
 * Oto interfejs zdalny komponentu Konto.
 *
 * Z tym interfejsem kontaktuja sie klienci podczas
 * wywolywania obiektow EJB. Dostawca komponentu
 * bedzie implementowal ten interfejs; zaimplementowany
 * obiekt jest tym obiektem EJB, ktory przekazuje
 * wywolania do odpowiedniego komponentu.
 */
public interface Konto extends EJBObject {

  /**
   * Wplaca okreslona kwote na konto.
   */
  public void wplac(double kwota) throws KontoException, RemoteException;
        
  /**
   * Wyplaca okreslona kwote z konta.
   * @throw KontoException, jesli kwota jest wieksza niz saldo
   */
  public void wyplac(double kwota) throws KontoException, RemoteException;

  // Metody pobierajace/ustawiajace wartosci pol komponentu encyjnego

  public double getSaldo() throws RemoteException;

  public String getNazwiskoWlasciciela() throws RemoteException;
  public void setNazwiskoWlasciciela(String nazwisko) throws RemoteException;

  public String getKontoID() throws RemoteException;
  public void setKontoID(String identyfikator) throws RemoteException;
}

