package przyklady;

import java.security.*;
import javax.naming.*;
import java.util.Hashtable;
import javax.rmi.PortableRemoteObject;

/**
 * To jest klasa pomocnicza, ktora odpowiada za bezposrednie wywolanie
 * komponentu "Witaj wiecie!". Metoda robi to w sposob bezpieczny,
 * automatycznie propagujac zalogowany kontekst bezpieczenstwa do
 * serwera J2EE.
 */
public class WywolajWitajSwiat implements PrivilegedAction {
 
 /*
  * To jest nasza metoda biznesowa. Wykonuje swoja akcje
  * bezpiecznie i zwraca wyniki specyficzne dla aplikacji.
  */
 public Object run() {
  String wynik = "Blad";
  try {
   /*
    * Tworzy komponent
    */
   Context kontekst = new InitialContext(System.getProperties());
   Object ob = kontekst.lookup("WitajDomowy");
   WitajDomowy domowy = (WitajDomowy) PortableRemoteObject.narrow(ob, WitajDomowy.class);
   Witaj witaj = domowy.create();

   /*
    * Wywoluje metode biznesowa, propagujac kontekst bezpieczenstwa
    */
   wynik = witaj.witaj();
  }
  catch (Exception e) {
   e.printStackTrace();
  }
  
  /*
   * Zwraca wynik do klienta
   */
  return wynik;
 }
}

