import java.util.*;
import org.omg.CosNaming.*;
import org.omg.CosTransactions.*;

public class KlientCORBA {

  public static void main(String[] args) throws Exception {

    /*
     * Inicjalizacja ORB.
     */
    Properties p = new Properties();
    p.put("org.omg.CORBA.ORBClass", <..Twoja klasa ORB..>);
    org.omg.CORBA.ORB orb = org.omg.CORBA.ORB.init(args, p);

    /*
     * Pobranie referencji do kontekstu nazw
     */
    NamingContext kontekst = NamingContextHelper.narrow
        (orb.resolve_initial_references("NameService"));

    /*
     * Wyszukanie obiektu domowego za pomoca COS Naming
     */
    NameComponent[] nazwy = { new NameComponent("WitajDomowy", "") };
    WitajDomowy witajDomowy = WitajDomowyHelper.narrow
        (kontekst.resolve(nazwy));

    /*
     * Pobranie interfejsu Current z CORBA OTS do kontroli transakcji
     */
    Current biezTX = CurrentHelper.narrow
        (orb.resolve_initial_references("TransactionCurrent"));

    /*
     * Poczatek transakcji
     */
    biezTX.begin();

    /*
     * Uycie obiektu domowego do utworzenia obiektu EJB
     */
    Witaj witaj = witajDomowy.create();

    /*
     * Wywolanie metody biznesowej
     */
    System.out.println(witaj.witaj());

    /*
     * Usuniecie obiektu EJB
     */
    witaj.remove();

    /*
     * Zatwierdzenie transakcji
     */
    biezTX.commit(true);
  }
}

