package przyklady;

import javax.ejb.*;
import javax.jms.*;

/**
 * Przykladowy komponent sterowany komunikatami
 */
public class DziennikKomponent implements MessageDrivenBean, MessageListener {

 protected MessageDrivenContext kontekst;

 /**
  * Laczy egzemplarz tego komponentu z konkretnym kontekstem.
  */
 public void setMessageDrivenContext(MessageDrivenContext kontekst) {
  this.kontekst = kontekst;
 }

 /**
  * Inicjalizuje komponent
  */
 public void ejbCreate() {
  System.err.println("ejbCreate()");
 }

 /**
  * Nasza jedyna metoda biznesowa
  */
 public void onMessage(Message komunikat) {

   TextMessage kt = (TextMessage) komunikat;

   try {
    String tekst = kt.getText();
    System.err.println("Otrzymany nowy komunikat: " + tekst);
   }
   catch(JMSException e) {
    e.printStackTrace();
   }
  }

 /**
  * Usuwa komponent
  */
 public void ejbRemove() {
  System.err.println("ejbRemove()");
 }
}
