package przyklady;

import javax.ejb.*;
import javax.naming.*;
import java.util.Properties;

/**
 * Ta klasa jest prostym przykladem kodu klienta.
 *
 * W tym przykladzie tworzymy 3 obiekty EJB, pozwalamy jednak kontenerowi
 * na przechowywanie w pamieci jedynie dwoch obiektow. W ten sposob
 * zademonstrujemy pasywacje komponentow.
 */
public class LicznikKlient {

  public static void main(String[] args) {

    try {
      /*
       * Pobiera wlasciwosci systemu niezbedne do inicjalizacji JNDI
       */
      Properties wlasciwosci = System.getProperties();

      /*
       * Pobiera odwolanie do obiektu domowego  posrednika do
       * obiektow EJB.
       */
      Context kontekst = new InitialContext(wlasciwosci);
      LicznikDomowy domowy = (LicznikDomowy)javax.rmi.PortableRemoteObject.narrow(kontekst.lookup("LicznikDomowy"), LicznikDomowy.class);

      /*
       * Tablica przechowujaca 3 obiekty EJB komponentu Licznik
       */
      Licznik licznik[] = new Licznik[3];

      int licznikWartosc = 0;

      /*
       * Tworzy obiekt i uruchamia metode licz() dla kazdego elementu tablicy
       */
      System.out.println("Tworzenie egzemplarzy komponentw...");
      for (int i=0; i < 3; i++) {
        /*
         * Tworzy obiekt EJB i inicjalizuje
         * go za pomoc aktualnej wartosci licznika.
         */
        licznik[i] = domowy.create(licznikWartosc);

        /*
         * Dodaj 1 i wyswietl
         */
        licznikWartosc = licznik[i].licz();

        System.out.println(licznikWartosc);

        /*
         * Poczekaj pol sekundy
         */
        Thread.sleep(500);
      }

      /*
       * Wywolajmy metode licz() dla kazdego obiektu EJB.
       * Upewnij sie, ze komponenty zostaly poprawnie
       * pasywowane i aktywowane.
       */
      System.out.println("Wywolanie metody licz() w komponentach...");
      for (int i=0; i < 3; i++) {

        /*
         * Dodaj 1 i wyswietl
         */
        licznikWartosc = licznik[i].licz();

        System.out.println(licznikWartosc);

        /*
         * Poczekaj pol sekundy
         */
        Thread.sleep(500);
      }

      /*
       * Zakonczylismy prace z obiektami EJB, mozemy je usunac
       */
      for (int i=0; i < 3; i++) {
        licznik[i].remove();
      }
    } catch (Exception e) {
      e.printStackTrace();
    }
  }
}
