# Questions

This is the issue tracker for Ember App Kit.
The Ember App Kit community uses this site
to collect and track bugs and discussions of new features.
If you are having difficulties or have a question about usage please ask a
question on StackOverflow: http://stackoverflow.com/questions/ask and tag
your question with `ember-app-kit`.

# Issues

Think you've found a bug or have a new feature to suggest? Let us know!

## Reporting a Bug
1. Update to the most recent master release if possible. We may have already
fixed your bug.

2. Search for similar issues. It's possible somebody has encountered
this bug already.

3. Provide with a bug report that shows the problem.

4. If possible, submit a Pull Request with a failing test. Better yet, take
a stab at fixing the bug yourself if you can!

The more information you provide, the easier it is for us to validate that
there is a bug and the faster we'll be able to take action.

# Pull Requests

We love pull requests. Here's a quick guide:

1. Fork the repo.

2. Run the tests. We only take pull requests with passing tests

3. Add a test for your change. Only refactoring and documentation changes
require no new tests. If you are adding functionality or fixing a bug, we need
a test!

4. Make the test pass.

5. Commit your changes. If your pull request fixes an issue specify it in the commit message.
Here's an example: `git commit -m "Close #52 – Fix controller and viewbindings"`

6. Push to your fork and submit a pull request. Please provide us with some
explanation of why you made the changes you made. For new features make sure to
explain a standard use case to us.

We try to be quick about responding to tickets but sometimes we get a bit
backlogged. If the response is slow, try to find someone on IRC (#emberjs) to
give the ticket a review.

# Website / Documentation

The project documentations is available at http://iamstef.net/ember-app-kit/

Ember App Kit is still under major development and contributions to the documentation are welcome!

1. Fork the repo.

2. Checkout the `gh-pages` branch

3. Make your changes

4. Commit and open a pull request against the `gh-pages` branch



NOTE: Partially copied from https://raw.github.com/emberjs/ember.js/master/CONTRIBUTING.md

