const int inputPin = A0;

// r2 to dolny stały rezystor w dzielniku napięcia
const float r2 = 1000.0;

// Cechy termistora
const float B = 3800.0;
const float r0 = 1000.0;

// Inne stałe
const float vin = 5.0;
const float t0k = 273.15;
const float t0 = t0k + 25;

void setup()
{
  pinMode(inputPin, INPUT);
  Serial.begin(9600);
}

void loop()
{
  int reading = analogRead(inputPin);
  float vout = reading / 204.6;
  float r = (r2 * (vin - vout)) / vout;

  float inv_t = 1.0/t0 + (1.0/B) * log(r/r0);
  float t = (1.0 / inv_t) - t0k;
  
  Serial.print(t); Serial.println(" (w stopniach C)");
  delay(500);
}
