// Nazwa pliku: ExtremeC_examples_chapter6_3.c
// Opis: Ten plik zawiera rzeczywistą definicję
//              struktury atrybutów `list_t`. Zawiera także
//              implementacje funkcji definiujących zachowanie udostępnianych
//              przez plik nagłówkowy. W tym pliku znajdują
//              się również prywatne funkcje definiujące zachowanie, które
//              są używane wewnętrznie.

#include <stdio.h>
#include <stdlib.h>

#define MAX_SIZE 10

// Zdefiniowanie aliasu typu bool_t.
typedef int bool_t;

// Zdefiniowanie typu list_t.
typedef struct {
  size_t size;
  int* items;
} list_t;

// Prywatna funkcja zachowania, która sprawdza, czy lista jest pełna.
bool_t __list_is_full(list_t* list) {
  return (list->size == MAX_SIZE);
}

// Kolejna prywatna funkcja zachowania, która sprawdza indeks.
bool_t __check_index(list_t* list, const int index) {
  return (index >= 0 && index <= list->size);
}

// Alokacja pamięci dla obiektu listy.
list_t* list_malloc() {
  return (list_t*)malloc(sizeof(list_t));
}

// Konstruktor obiektu listy.
void list_init(list_t* list) {
  list->size = 0;
  // Alokacja pamięci na stercie.
  list->items = (int*)malloc(MAX_SIZE * sizeof(int));
}

// Destruktor obiektu listy.
void list_destroy(list_t* list) {
  // Zwolnienie wcześniej zarezerwowanej pamięci na stercie.
  free(list->items);
}

int list_add(list_t* list, const int item) {
  // Użycie prywatnej funkcji zachowania.
  if (__list_is_full(list)) {
    return -1;
  }
  list->items[list->size++] = item;
  return 0;
}

int list_get(list_t* list, const int index, int* result) {
  if (__check_index(list, index)) {
    *result = list->items[index];
    return 0;
  }
  return -1;
}

void list_clear(list_t* list) {
  list->size = 0;
}

size_t list_size(list_t* list) {
  return list->size;
}

void list_print(list_t* list) {
  printf("[");
  for (size_t i = 0; i < list->size; i++) {
    printf("%d ", list->items[i]);
  }
  printf("]\n");
}
