// Nazwa pliku: ExtremeC_examples_chapter17_5.c
// Opis: Przykład odczytywania informacji z obiektu pamięci współdzielonej.

#include <stdio.h>
#include <unistd.h>
#include <fcntl.h>
#include <errno.h>
#include <string.h>
#include <sys/mman.h>

#define SH_SIZE 16

int main(int argc, char** argv) {
  int shm_fd = shm_open("/shm0", O_RDONLY, 0600);
  if (shm_fd < 0) {
    fprintf(stderr, "BŁĄD! Nie udało się otworzyć obiektu pamięci współdzielonej: %s\n",
        strerror(errno));
    return 1;
  }
  fprintf(stdout, "Obiekt pamięci współdzielonej został otworzony z użyciem deskryptora pliku o wartości: %d\n", shm_fd);
  void* map = mmap(0, SH_SIZE, PROT_READ, MAP_SHARED, shm_fd, 0);
  if (map == MAP_FAILED) {
    fprintf(stderr, "BŁĄD! Mapowanie zakończyło się niepowodzeniem: %s\n",
            strerror(errno));
    return 1;
  }
  char* ptr = (char*)map;
  fprintf(stdout, "Oto zawartość obiektu pamięci współdzielonej: %s\n",
          ptr);
  if (munmap(ptr, SH_SIZE) < 0) {
    fprintf(stderr, "BŁĄD! Usunięcie mapowania zakończyło się niepowodzeniem: %s\n",
            strerror(errno));
    return 1;
  }
  if (close(shm_fd) < 0) {
    fprintf(stderr, "BŁĄD! Zamknięcie obiektu pamięci współdzielonej z deskryptorem pliku o wartości: %s\n",
        strerror(errno));
    return 1;
  }
  if (shm_unlink("/shm0") < 0) {
    fprintf(stderr, "BŁĄD! Zwolnienie pamięci współdzielonej zakończyło się niepowodzeniem: %s\n",
        strerror(errno));
    return 1;
  }
  return 0;
}
