// Nazwa pliku: ExtremeC_examples_chapter8_2_student.c
// Opis: Implementacja prywatna klkasy Student.

#include <stdlib.h>
#include <string.h>

#include "ExtremeC_examples_chapter8_2_person.h"

// Struktura person_t została zdefiniowana w następującym pliku nagłówkowym,
// który będzie tutaj potrzebny.
#include "ExtremeC_examples_chapter8_2_person_p.h"

//Deklaracja wyprzedzająca.
typedef struct {
  // Tutaj dziedziczymy wszystkie atrybuty po klasie person,
  // a ponadto możemy użyć jej wszystkich funkcji zachowania,
  // ponieważ jest to klasa zagnieżdżona.
  person_t person;
  char* student_number;
  unsigned int passed_credits;
} student_t;

// Alokator pamięci.
student_t* student_new() {
  return (student_t*)malloc(sizeof(student_t));
}

// Konstruktor.
void student_ctor(student_t* student, 
                  const char* first_name, 
                  const char* last_name, 
                  unsigned int birth_year,
                  const char* student_number,
                  unsigned int passed_credits) {
  // Wywołanie konstruktora klasy nadrzędnej.
  person_ctor((struct person_t*)student,
          first_name, last_name, birth_year);
  student->student_number = (char*)malloc(16 * sizeof(char));
  strcpy(student->student_number, student_number);
  student->passed_credits = passed_credits;
}

// Destruktor.
void student_dtor(student_t* student) {
  // Najpierw trzeba usunąć obiekt potomny..
  free(student->student_number);
  // Następnie należy wywołać funkcję destruktora
  // klasy nadrzędnej.
  person_dtor((struct person_t*)student);
}

// Funkcje definiujące zachowanie.
void student_get_student_number(student_t* student, 
                                char* buffer) {
  strcpy(buffer, student->student_number);
}

unsigned int student_get_passed_credits(student_t* student) {
  return student->passed_credits;
}
