// Nazwa pliku: ExtremeC_examples_chapter3_2_2d.c
// Opis: Implementacje funkcji geometrycznych działających na płaszczyźnie 2D.

#include <math.h>

// Konieczne jest dołączenie pliku nagłówkowego, ponieważ
// zamierzamy używać typów polar_pos_2d_t, cartesian_pos_2d_t
// itd. oraz pozostałych funkcji trygonometrycznych zaimplementowanych
// w innym pliku kodu źródłowego.
#include "ExtremeC_examples_chapter3_2_geometry.h"

cartesian_pos_2d_t convert_to_2d_cartesian_pos(
        const polar_pos_2d_t* polar_pos) {
  cartesian_pos_2d_t result;
  result.x = polar_pos->length * cos_deg(polar_pos->theta);
  result.y = polar_pos->length * sin_deg(polar_pos->theta);
  return result;
}

polar_pos_2d_t convert_to_2d_polar_pos(
        const cartesian_pos_2d_t* cartesian_pos) {
  polar_pos_2d_t result;
  result.length = sqrt(cartesian_pos->x * cartesian_pos->x +
    cartesian_pos->y * cartesian_pos->y);
  result.theta =
      to_degree(atan(cartesian_pos->y / cartesian_pos->x));
  return result;
}
