#include <linux/kernel.h>   // Plik nagłówkowy wymagany przez printk.
#include <linux/string.h>   // Plik nagłówkowy wymagany przez strcpy, strcat, strlen.
#include <linux/slab.h>     // Plik nagłówkowy wymagany przez kmalloc, kfree.
#include <linux/uaccess.h>  // Plik nagłówkowy wymagany przez copy_from_user, copy_to_user.
#include <linux/syscalls.h> // Plik nagłówkowy wymagany przez SYSCALL_DEFINE4.

// Definicja wywołania systemowego.
SYSCALL_DEFINE4(hello_world,
  const char __user *, str,    // Ciąg tekstowy danych wejściowych.
  const unsigned int, str_len, // Wielkość danych wejściowych.
  char __user *, buf,          // Bufor danych wyjściowych.
  unsigned int, buf_len) {     // Wielkość bufora danych wyjściowych.
  // Zmienna stosu jądra przeznaczona do przechowywania
  // zawartości bufora danych wejściowych.
  char name[64];
  // Zmienna stosu jądra przeznaczona do przechowywania
  // ostatecznego komunikatu danych wyjściowych.
  char message[96];

  printk("Wykonanie wywołania systemowego!\n");
  if (str_len >= 64) {
    printk("Zbyt długi ciąg tekstowy danych wejściowych.\n");
    return -1;
  }

  // Skopiowanie danych z przestrzeni użytkownika do przestrzeni jądra.
  if (copy_from_user(name, str, str_len)) {
    printk("Nie udało się skopiować danych z przestrzeni użytkownika.\n");
    return -2;
  }

  // Przygotowanie ostatecznego komunikatu.
  strcpy(message, "Witaj, ");
  strcat(message, name);
  strcat(message, "!");

  // Sprawdzenie, czy ostateczny komunikat może się zmieścić w buforze danych wyjściowych.
  if (strlen(message) >= (buf_len - 1)) {
    printk("Zbyt mały bufor danych wyjściowych.\n");
    return -3;
  }

  // Skopiowanie komunikatu z przestrzeni jądra do przestrzeni użytkownika.
  if (copy_to_user(buf, message, strlen(message) + 1)) {
    printk("Nie udało się skopiować danych do przestrzeni użytkownika.\n");
    return -4;
  }

  // Umieszczenie komunikatu w dzienniku zdarzeń jądra.
  printk("Komunikat: %s\n", message);
  return 0;
}
