// Nazwa pliku: ExtremeC_examples_chapter5_5.c
// Opis: Przykład 5.5

#include <stdio.h> // Ten plik nagłówkowy jest potrzebny do działania funkcji printf().
#include <stdlib.h> // Ten plik nagłówkowy jest potrzebny do działania funkcji dotyczących pamięci sterty.

#define QUEUE_MAX_SIZE 100

typedef struct {
  int front;
  int rear;
  double* arr;
} queue_t;

void init(queue_t* q) {
  q->front = q->rear = 0;
  // Właścicielem zaalokowanego w tym miejscu bloku
  // pamięci sterty jest obiekt kolejki.
  q->arr = (double*)malloc(QUEUE_MAX_SIZE * sizeof(double));
}

void destroy(queue_t* q) {
  free(q->arr);
}

int size(queue_t* q) {
  return q->rear - q->front;
}

void enqueue(queue_t* q, double item) {
  q->arr[q->rear] = item;
  q->rear++;
}

double dequeue(queue_t* q) {
  double item = q->arr[q->front];
  q->front++;
  return item;
}

int main(int argc, char** argv) {
  // Właścicielem zaalokowanego w tym miejscu bloku
  // pamięci sterty jest funkcja main().
  queue_t* q = (queue_t*)malloc(sizeof(queue_t));

  // Alokacja pamięci niezbędnej dla obiektu kolejki.
  init(q);

  enqueue(q, 6.5);
  enqueue(q, 1.3);
  enqueue(q, 2.4);

  printf("%f\n", dequeue(q));
  printf("%f\n", dequeue(q));
  printf("%f\n", dequeue(q));

  // Zwolnienie zasobów pamięci sterty zarezerwowanych przez obiekt kolejki.
  destroy(q);

  // Zwolnienie pamięci zarezerwowanej dla
  // obiektu kolejki przez funkcję main().
  free(q);
  return 0;
}
