/* Nazwa pliku: Stack.cpp
 * Opis: Klasa C++ opakowująca funkcjonalność udostępnianą przez
 * współdzieloną bibliotekę stosu. Zawiera również kod
 * pozwalający na przetestowanie funkcjonalności stosu.
 */

#include <string.h>

#include <iostream>
#include <string>

#include "cstack.h"

template<typename T>
value_t CreateValue(const T& pValue);

template<typename T>
T ExtractValue(const value_t& value);

template<typename T>
class Stack {
public:
  // Konstruktor.
  Stack(int pMaxSize) {
    mStack = cstack_new();
    cstack_ctor(mStack, pMaxSize);
  }

  // Destruktor.
  ~Stack() {
    cstack_dtor(mStack, free_value);
    cstack_delete(mStack);
  }

  size_t Size() {
    return cstack_size(mStack);
  }

  void Push(const T& pItem) {
    value_t value = CreateValue(pItem);
    if (!cstack_push(mStack, value)) {
      throw "Stos jest pełny!";
    }
  }

  const T Pop() {
    value_t value;
    if (!cstack_pop(mStack, &value)) {
      throw "Stos jest pusty!";
    }
    T toReturn = ExtractValue<T>(value);
    free_value(&value);
    return toReturn;
  }

  void Clear() {
    cstack_clear(mStack, free_value);
  }

private:
  cstack_t* mStack;
};

// Specjalizowane funkcje szablonu.
template<>
value_t CreateValue(const std::string& pValue) {
  value_t value;
  value.len = pValue.size() + 1;
  value.data = (char *)malloc(value.len * sizeof(char));
  strcpy(value.data, pValue.c_str());
  return value;
}

template<>
std::string ExtractValue(const value_t& value) {
  return std::string(value.data, value.len);
}

int main(int argc, char** argv) {
  Stack<std::string> stringStack(100);
  stringStack.Push("Witaj,");
  stringStack.Push("świecie");
  stringStack.Push("!");
  std::cout << "Wielkość stosu: " << stringStack.Size() << std::endl;
  while (stringStack.Size() > 0) {
    std::cout << "Usunięto > " << stringStack.Pop() << std::endl;
  }
  std::cout << "Wielkość stosu po usunięciu obiektu: " <<
      stringStack.Size() << std::endl;
  stringStack.Push("Żegnaj");
  stringStack.Push("Żegnaj");
  std::cout << "Wielkość stosu przed czyszczeniem: " <<
      stringStack.Size() << std::endl;
  stringStack.Clear();
  std::cout << "Wielkość stosu po czyszczeniu: " <<
      stringStack.Size() << std::endl;
  return 0;
}
