// Nazwa pliku: hwkm.c
// Opis: Moduł jądra Hello World.

#include <linux/module.h>
#include <linux/kernel.h>
#include <linux/init.h>
#include <linux/proc_fs.h>

// Struktura prowadząca do pliku w katalogu /proc.
struct proc_dir_entry *proc_file;

// Funkcja wywołania zwrotnego.
ssize_t proc_file_read(struct file *file, char __user *ubuf, size_t count, loff_t *ppos) {
  int copied = 0;
  if (*ppos > 0) {
    return 0;
  }
  copied = sprintf(ubuf, "Witaj, świecie z modułu jądra!\n");
  *ppos = copied;
  return copied;
}

static const struct file_operations proc_file_fops = {
 .owner = THIS_MODULE,
 .read  = proc_file_read
};

// Wywołanie zwrotne inicjalizujące moduł.
static int __init hwkm_init(void) {
  proc_file = proc_create("hwkm", 0, NULL, &proc_file_fops);
  if (!proc_file) {
    return -ENOMEM;
  }
  printk("Moduł Hello World został wczytany.\n");
  return 0;
}

// Wywołanie zwrotne exit modułu.
static void __exit hkwm_exit(void) {
  proc_remove(proc_file);
  printk("Żegnaj, świecie!\n");
}

// Zdefiniowanie wywołań zwrotnych modułu.
module_init(hwkm_init);
module_exit(hkwm_exit);
