// Nazwa pliku: ExtremeC_examples_chapter8_4_cat.c
// Opis: Definicje prywatne klasy Cat.

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "ExtremeC_examples_chapter8_4_animal.h"
#include "ExtremeC_examples_chapter8_4_animal_p.h"

typedef struct {
  animal_t animal;
} cat_t;

// Definicja nowej funkcji zachowania __cat_sound().
void __cat_sound(void* ptr) {
  animal_t* animal = (animal_t*)ptr;
  printf("%s: Miau\n", animal->name);
}

// Alokator pamięci.
cat_t* cat_new() {
  return (cat_t*)malloc(sizeof(cat_t));
}

// Konstruktor.
void cat_ctor(cat_t* cat) {
  animal_ctor((struct animal_t*)cat);
  strcpy(cat->animal.name, "Cat");
  // Prowadzi do nowej funkcji zachowania. Nadpisanie
  // faktycznie odbywa się w tym miejscu.
  cat->animal.sound_func = __cat_sound; 
}

// Destruktor.
void cat_dtor(cat_t* cat) {
  animal_dtor((struct animal_t*)cat);
}
