// Nazwa pliku: ExtremeC_examples_chapter19_1.c
// Opis: Przykład obsługi sygnałów.

#include <stdio.h>
#include <stdlib.h>
#include <signal.h>

void handle_user_signals(int signal) {
  switch (signal) {
    case SIGUSR1:
      printf("Otrzymano sygnał SIGUSR1!\n");
      break;
    case SIGUSR2:
      printf("Otrzymano sygnał SIGUSR2!\n");
      break;
    default:
      printf("Otrzymano nieobsługiwany sygnał!\n");
  }
}

void handle_sigint(int signal) {
  printf("Otrzymano sygnał Interrupt!\n");
}

void handle_sigkill(int signal) {
  printf("Otrzymano sygnał Kill! Żegnaj.\n");
  exit(0);
}

int main(int argc, char** argv) {
  signal(SIGUSR1, handle_user_signals);
  signal(SIGUSR2, handle_user_signals);
  signal(SIGINT, handle_sigint);
  signal(SIGKILL, handle_sigkill);
  while (1);
  return 0;
}
