// Nazwa pliku: ExtremeC_examples_chapter7_2_main.c
// Opis: Funkcja main() używająca obiektów klas Player i Gun.

#include <stdio.h>
#include <stdlib.h>

#include "ExtremeC_examples_chapter7_2_player.h"
#include "ExtremeC_examples_chapter7_2_gun.h"

int main(int argc, char** argv) {
  // Utworzenie obiektu przedstawiającego broń.
  struct gun_t* gun = gun_new();
  gun_ctor(gun, 3);

  // Utworzenie obiektu przedstawiającego gracza.
  struct player_t* player = player_new();
  player_ctor(player, "Billy");

  // Początek związku agregacji.
  player_pickup_gun(player, gun);

  // Oddawanie strzałów aż do wyczerpania amunicji.
  while (gun_has_bullets(gun)) {
    player_shoot(player);
  }

  // Zmiana magazynku.
  gun_refill(gun);

  // Oddawanie strzałów aż do wyczerpania amunicji.
  while (gun_has_bullets(gun)) {
    player_shoot(player);
  }

  // Zakończenie związku agregacji.
  player_drop_gun(player);

  // Usunięcie obiektu przedstawiającego gracza i zwolnienie zarezerwowanej dla niego pamięci.
  player_dtor(player);
  free(player);

  // Usunięcie obiektu przedstawiającego broń i zwolnienie zarezerwowanej dla niego pamięci.
  gun_dtor(gun);
  free(gun);

  return 0;
}
