// Nazwa pliku: ExtremeC_examples_chapter7_2_player.c
// Opis: Implementacja klasy Player.

#include <stdlib.h>
#include <string.h>
#include <stdio.h>

#include "ExtremeC_examples_chapter7_2_gun.h"

// Struktura atrybutów.
typedef struct {
  char* name;
  struct gun_t* gun;
} player_t;

// Alokator pamięci.
player_t* player_new() {
  return (player_t*)malloc(sizeof(player_t));
}

// Konstruktor.
void player_ctor(player_t* player, const char* name) {
  player->name =
      (char*)malloc((strlen(name) + 1) * sizeof(char));
  strcpy(player->name, name);
  // To jest ważne polecenie. Konieczne jest przypisanie wartości null wskaźnikowi
  // agregacji, jeżeli w konstruktorze nie zostanie mu przypisana żadna wartość.
  player->gun = NULL;
}

// Destruktor.
void player_dtor(player_t* player) {
  free(player->name);
}

// Funkcje definiujące zachowanie.
void player_pickup_gun(player_t* player, struct gun_t* gun) {
  // Po wykonaniu tego polecenia rozpoczyna się związek agregacji.
  player->gun = gun;
}

void player_shoot(player_t* player) {
  // Trzeba sprawdzić, czy gracz wybrał broń.
  // W przeciwnym razie strzelanie jest bez znaczenia.
  if (player->gun) {
    gun_trigger(player->gun);
  } else {
    printf("Gracz chce strzelać, ale nie ma broni!");
    exit(1);
  }
}

void player_drop_gun(player_t* player) {
  // Po wykonaniu tego polecenia związek agregacji zachodzący między dwoma
  // obiektami zostanie zakończony. Zwróć uwagę na to, że obiekt przedstawiający
  // broń nie powinien zostać usunięty, ponieważ obiekt kontenera nie jest jego
  // właścicielem, jak ma to miejsce na przykład w przypadku kompozycji.
  player->gun = NULL;
}
