#!/usr/bin/env PYTHONHASHSEED=1234 python3

# Copyright 2014-2024 Brett Slatkin, Pearson Education Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

### Początek sekcji konfiguracji środowiska
import random
random.seed(1234)

import logging
from pprint import pprint
from sys import stdout as STDOUT

# Zapisywanie wszystkich danych wyjściowych w katalogu tymczasowym
import atexit
import gc
import io
import os
import tempfile

TEST_DIR = tempfile.TemporaryDirectory()
atexit.register(TEST_DIR.cleanup)

# Eleganckie zakończenie procesów systemu Windows
OLD_CWD = os.getcwd()
atexit.register(lambda: os.chdir(OLD_CWD))
os.chdir(TEST_DIR.name)

def close_open_files():
    everything = gc.get_objects()
    for obj in everything:
        if isinstance(obj, io.IOBase):
            obj.close()

atexit.register(close_open_files)
### Koniec sekcji konfiguracji środowiska


print("Przykład 1")
my_test1 = "witaj" "świecie"
my_test2 = "witaj" + "świecie"
assert my_test1 == my_test2


print("Przykład 2")
x = 1
my_test1 = (
    r"tutaj \ znajduje się część pierwsza razem z ukośnikami\n, "
    f"tutaj mamy interpolację ciągu tekstowego {x}, "
    'ten ciąg tekstowy zawiera znaki "cudzysłów"'
)
print(my_test1)


print("Przykład 3")
y = 2
my_test2 = r"pier\wszy", f"{y}" '"trzeci"'
print(my_test2)


print("Przykład 4")
my_test3 = r"pier\wszy", f"{y}" '"trzeci"'
print(my_test3)


print("Przykład 5")
my_test4 = [
    "pierwszy wiersz\n",
    "drugi wiersz\n",
    "trzeci wiersz\n",
]
print(my_test4)


print("Przykład 6")
my_test5 = [
    "pierwszy wiersz\n",
    "drugi wiersz\n"  # Brak przecinka
    "trzeci wiersz\n",
]
print(my_test5)


print("Przykład 7")
my_test5 = [
    "pierwszy wiersz\n",
    "drugi wiersz\n" "trzeci wiersz\n",
]


print("Przykład 8")
my_test6 = [
    "pierwszy wiersz\n",
    "drugi wiersz\n" +  # Jawna konkatenacja
    "trzeci wiersz\n",
]
assert my_test5 == my_test6


print("Przykład 9")
my_test6 = [
    "pierwszy wiersz\n",
    "drugi wiersz\n" + "trzeci wiersz\n",
]


print("Przykład 10")
print("to jest mój długi komunikat "
      "przeznaczony do wyświetlenia")


print("Przykład 11")
import sys

print("to jest mój długi komunikat "
      "przeznaczony do wyświetlenia",
      end="",
      file=sys.stderr)


print("Przykład 12")
import sys

first_value = ...
second_value = ...

class MyData:
    def __init__(self, *args, **kwargs):
        self.args = args
        self.kwargs = kwargs

value = MyData(123,
               first_value,
               f"ciąg tekstowy formatowania {x}"
               f"inna wartość {y}",
               "a to jest kolejny tekst",
               second_value,
               stream=sys.stderr)


print("Przykład 13")
value2 = MyData(123,
                first_value,
                f"ciąg tekstowy formatowania {x}" +  # Jawna konkatenacja
                f"inna wartość {y}",
                "a to jest kolejny tekst",
                second_value,
                stream=sys.stderr)
