#!/usr/bin/env PYTHONHASHSEED=1234 python3

# Copyright 2014-2024 Brett Slatkin, Pearson Education Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

### Początek sekcji konfiguracji środowiska
import random
random.seed(1234)

import logging
from pprint import pprint
from sys import stdout as STDOUT

# Zapisywanie wszystkich danych wyjściowych w katalogu tymczasowym
import atexit
import gc
import io
import os
import tempfile

TEST_DIR = tempfile.TemporaryDirectory()
atexit.register(TEST_DIR.cleanup)

# Eleganckie zakończenie procesów systemu Windows
OLD_CWD = os.getcwd()
atexit.register(lambda: os.chdir(OLD_CWD))
os.chdir(TEST_DIR.name)

def close_open_files():
    everything = gc.get_objects()
    for obj in everything:
        if isinstance(obj, io.IOBase):
            obj.close()

atexit.register(close_open_files)
### Koniec sekcji konfiguracji środowiska


print("Przykład 1")
numbers = [93, 86, 11, 68, 70]
numbers.sort()
print(numbers)


print("Przykład 2")
class Tool:
    def __init__(self, name, weight):
        self.name = name
        self.weight = weight

    def __repr__(self):
        return f"Tool({self.name!r}, {self.weight})"

tools = [
    Tool("poziomica", 3.5),
    Tool("młotek", 1.25),
    Tool("śrubokręt", 0.5),
    Tool("dłuto", 0.25),
]


print("Przykład 3")
try:
    tools.sort()
except:
    logging.exception('Oczekiwane')
else:
    assert False


print("Przykład 4")
print("Nieposortowane:", repr(tools))
tools.sort(key=lambda x: x.name)
print("\nPosortowane:  ", tools)


print("Przykład 5")
tools.sort(key=lambda x: x.weight)
print("Według wagi:", tools)


print("Przykład 6")
places = ["dom", "praca", "Nowy Jork", "Paryż"]
places.sort()
print("Uwzględniona wielkość liter:  ", places)
places.sort(key=lambda x: x.lower())
print("Nieuwzględniona wielkość liter:", places)


print("Przykład 7")
power_tools = [
    Tool("wiertarka", 4),
    Tool("piła tarczowa", 5),
    Tool("wiertarka udarowa", 40),
    Tool("szlifierka", 4),
]


print("Przykład 8")
saw = (5, "piła tarczowa")
jackhammer = (40, "wiertarka udarowa")
assert not (jackhammer < saw)  # Dopasowanie oczekiwań


print("Przykład 9")
drill = (4, "wiertarka")
sander = (4, "szlifierka")
assert drill[0] == sander[0]  # Taka sama waga
assert drill[1] < sander[1]   # Mniejszy pod względem alfabetycznym
assert drill < sander         # Dlatego młotek jest pierwszy


print("Przykład 10")
power_tools.sort(key=lambda x: (x.weight, x.name))
print(power_tools)


print("Przykład 11")
power_tools.sort(
    key=lambda x: (x.weight, x.name),
    reverse=True,  # Powoduje, że wszystkie kryteria są malejące
)
print(power_tools)


print("Przykład 12")
power_tools.sort(key=lambda x: (-x.weight, x.name))
print(power_tools)


print("Przykład 13")
try:
    power_tools.sort(key=lambda x: (x.weight, -x.name), reverse=True)
except:
    logging.exception('Oczekiwane')
else:
    assert False


print("Przykład 14")
power_tools.sort(
    key=lambda x: x.name,    # Wartość name w kolejności rosnącej
)
power_tools.sort(
    key=lambda x: x.weight,  # Wartość weight w kolejności malejącej
    reverse=True,
)
print(power_tools)


print("Przykład 15")
power_tools.sort(key=lambda x: x.name)
print(power_tools)


print("Przykład 16")
power_tools.sort(
    key=lambda x: x.weight,
    reverse=True,
)
print(power_tools)
