#!/usr/bin/env PYTHONHASHSEED=1234 python3

# Copyright 2014-2024 Brett Slatkin, Pearson Education Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

### Początek sekcji konfiguracji środowiska
import random
random.seed(1234)

import logging
from pprint import pprint
from sys import stdout as STDOUT

# Zapisywanie wszystkich danych wyjściowych w katalogu tymczasowym
import atexit
import gc
import io
import os
import tempfile

TEST_DIR = tempfile.TemporaryDirectory()
atexit.register(TEST_DIR.cleanup)

# Eleganckie zakończenie procesów systemu Windows
OLD_CWD = os.getcwd()
atexit.register(lambda: os.chdir(OLD_CWD))
os.chdir(TEST_DIR.name)

def close_open_files():
    everything = gc.get_objects()
    for obj in everything:
        if isinstance(obj, io.IOBase):
            obj.close()

atexit.register(close_open_files)
### Koniec sekcji konfiguracji środowiska


print("Przykład 1")
counters = {
    "pumpernikiel": 2,
    "na zakwasie": 1,
}


print("Przykład 2")
key = "pszenica"

if key in counters:
    count = counters[key]
else:
    count = 0

counters[key] = count + 1
print(counters)


print("Przykład 3")
key = "brioszka"

try:
    count = counters[key]
except KeyError:
    count = 0

counters[key] = count + 1

print(counters)


print("Przykład 4")
key = "wieloziarnisty"

count = counters.get(key, 0)
counters[key] = count + 1

print(counters)


print("Przykład 5")
key = "bagietka"

if key not in counters:
    counters[key] = 0
counters[key] += 1

key = "ciabata"

if key in counters:
    counters[key] += 1
else:
    counters[key] = 1

key = "ciabata"

try:
    counters[key] += 1
except KeyError:
    counters[key] = 1

print(counters)


print("Przykład 6")
votes = {
    "bagietka": ["Bartek", "Alicja"],
    "ciabata": ["Celina", "Dorota"],
}

key = "brioszka"
who = "Ela"

if key in votes:
    names = votes[key]
else:
    votes[key] = names = []

names.append(who)
print(votes)


print("Przykład 7")
key = "żyto"
who = "Felicjan"

try:
    names = votes[key]
except KeyError:
    votes[key] = names = []

names.append(who)

print(votes)


print("Przykład 8")
key = "pszenica"
who = "Gertrude"

names = votes.get(key)
if names is None:
    votes[key] = names = []

names.append(who)

print(votes)


print("Przykład 9")
key = "brioszka"
who = "Henryk"

if (names := votes.get(key)) is None:
    votes[key] = names = []

names.append(who)

print(votes)


print("Przykład 10")
key = "mąka kukurydziana"
who = "Krzysztof"

names = votes.setdefault(key, [])
names.append(who)

print(votes)


print("Przykład 11")
data = {}
key = "foo"
value = []
data.setdefault(key, value)
print("Przed:", data)
value.append("witaj")
print("Po: ", data)


print("Przykład 12")
key = "ciastko holenderskie"

count = counters.setdefault(key, 0)
counters[key] = count + 1

print(counters)
