#!/usr/bin/env PYTHONHASHSEED=1234 python3

# Copyright 2014-2024 Brett Slatkin, Pearson Education Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

### Początek sekcji konfiguracji środowiska
import random
random.seed(1234)

import logging
from pprint import pprint
from sys import stdout as STDOUT

# Zapisywanie wszystkich danych wyjściowych w katalogu tymczasowym
import atexit
import gc
import io
import os
import tempfile

TEST_DIR = tempfile.TemporaryDirectory()
atexit.register(TEST_DIR.cleanup)

# Eleganckie zakończenie procesów systemu Windows
OLD_CWD = os.getcwd()
atexit.register(lambda: os.chdir(OLD_CWD))
os.chdir(TEST_DIR.name)

def close_open_files():
    everything = gc.get_objects()
    for obj in everything:
        if isinstance(obj, io.IOBase):
            obj.close()

atexit.register(close_open_files)
### Koniec sekcji konfiguracji środowiska


print("Przykład 1")
import itertools


print("Przykład 2")
it = itertools.chain([1, 2, 3], [4, 5, 6])
print(list(it))


print("Przykład 3")
it1 = [i * 3 for i in ("a", "b", "c")]
it2 = [j * 2 for j in ("x", "y", "z")]
nested_it = [it1, it2]
output_it = itertools.chain.from_iterable(nested_it)
print(list(output_it))


print("Przykład 4")
it = itertools.repeat("witaj", 3)
print(list(it))


print("Przykład 5")
it = itertools.cycle([1, 2])
result = [next(it) for _ in range(10)]
print(result)


print("Przykład 6")
it1, it2, it3 = itertools.tee(["pierwszy", "drugi"], 3)
print(list(it1))
print(list(it2))
print(list(it3))


print("Przykład 7")
keys = ["jeden", "dwa", "trzy"]
values = [1, 2]

normal = list(zip(keys, values))
print("zip:        ", normal)

it = itertools.zip_longest(keys, values, fillvalue="brak")
longest = list(it)
print("zip_longest:", longest)


print("Przykład 8")
values = [1, 2, 3, 4, 5, 6, 7, 8, 9, 10]

first_five = itertools.islice(values, 5)
print("Pierwsze pięć: ", list(first_five))

middle_odds = itertools.islice(values, 2, 8, 2)
print("Środkowe nieparzyste:", list(middle_odds))


print("Przykład 9")
values = [1, 2, 3, 4, 5, 6, 7, 8, 9, 10]
less_than_seven = lambda x: x < 7
it = itertools.takewhile(less_than_seven, values)
print(list(it))


print("Przykład 10")
values = [1, 2, 3, 4, 5, 6, 7, 8, 9, 10]
less_than_seven = lambda x: x < 7
it = itertools.dropwhile(less_than_seven, values)
print(list(it))


print("Przykład 11")
values = [1, 2, 3, 4, 5, 6, 7, 8, 9, 10]
evens = lambda x: x % 2 == 0

filter_result = filter(evens, values)
print("filter():      ", list(filter_result))

filter_false_result = itertools.filterfalse(evens, values)
print("filterfalse():", list(filter_false_result))


print("Przykład 12")
it = itertools.batched([1, 2, 3, 4, 5, 6, 7, 8, 9], 3)
print(list(it))


print("Przykład 13")
it = itertools.batched([1, 2, 3], 2)
print(list(it))


print("Przykład 14")
route = ["Los Angeles", "Bakersfield", "Modesto", "Sacramento"]
it = itertools.pairwise(route)
print(list(it))


print("Przykład 15")
values = [1, 2, 3, 4, 5, 6, 7, 8, 9, 10]
sum_reduce = itertools.accumulate(values)
print("Suma:   ", list(sum_reduce))

def sum_modulo_20(first, second):
    output = first + second
    return output % 20

modulo_reduce = itertools.accumulate(values, sum_modulo_20)
print("Modulo:", list(modulo_reduce))


print("Przykład 16")
single = itertools.product([1, 2], repeat=2)
print("Pojedynczo:  ", list(single))

multiple = itertools.product([1, 2], ["a", "b"])
print("Wielokrotnie:", list(multiple))


print("Przykład 17")
it = itertools.permutations([1, 2, 3, 4], 2)
original_print = print
print = pprint
print(list(it))
print = original_print


print("Przykład 18")
it = itertools.combinations([1, 2, 3, 4], 2)
print(list(it))


print("Przykład 19")
it = itertools.combinations_with_replacement([1, 2, 3, 4], 2)
original_print = print
print = pprint
print(list(it))
print = original_print
