#!/usr/bin/env python3

# Copyright 2014 Brett Slatkin, Pearson Education Inc.
#
# Udostępniono na licencji Apache w wersji 2.0 ("Licencja").
# Tego pliku można używać jedynie zgodnie z warunkami Licencji.
# Treść Licencji znajdziesz na stronie:
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# O ile obowiązujące prawo nie stanowi inaczej lub czegoś innego nie
# uzgodniono w formie pisemnej, oprogramowanie objęte Licencją jest
# dostarczane w stanie, w jakim jest (wersja "AS IS"), BEZ JAKIEJKOLWIEK
# GWARANCJI, ani wyrażonej otwarcie, ani domyślnej. Dokładne zasady
# i warunki Licencji znajdziesz w jej treści.

# Przygotowania mające na celu odtworzenie środowiska użytego w książce.
import logging
from pprint import pprint
from sys import stdout as STDOUT


# Przykład 1.
from collections import deque
fifo = deque()
fifo.append(1)      # Producent.
fifo.append(2)
fifo.append(3)
x = fifo.popleft()  # Konsument.
print(x)


# Przykład 2.
a = {}
a['foo'] = 1
a['bar'] = 2
from random import randint

# Losowe wypełnienie 'b' spowoduje konflikt w tabeli hash.
while True:
    z = randint(99, 1013)
    b = {}
    for i in range(z):
        b[i] = i
    b['foo'] = 1
    b['bar'] = 2
    for i in range(z):
        del b[i]
    if str(b) != str(a):
        break

print(a)
print(b)
print('Równość?', a == b)


# Przykład 3.
from collections import OrderedDict
a = OrderedDict()
a['foo'] = 1
a['bar'] = 2

b = OrderedDict()
b['foo'] = 'czerwony'
b['bar'] = 'niebieski'

for value1, value2 in zip(a.values(), b.values()):
    print(value1, value2)


# Przykład 4.
stats = {}
key = 'my_counter'
if key not in stats:
    stats[key] = 0
stats[key] += 1
print(stats)


# Przykład 5.
from collections import defaultdict
stats = defaultdict(int)
stats['my_counter'] += 1
print(dict(stats))


# Przykład 6.
from heapq import *
a = []
heappush(a, 5)
heappush(a, 3)
heappush(a, 7)
heappush(a, 4)


# Przykład 7.
print(heappop(a), heappop(a), heappop(a), heappop(a))


# Przykład 8.
a = []
heappush(a, 5)
heappush(a, 3)
heappush(a, 7)
heappush(a, 4)
assert a[0] == nsmallest(1, a)[0] == 3


# Przykład 9.
print('Przed:', a)
a.sort()
print('Po: ', a)


# Przykład 10.
x = list(range(10**6))
i = x.index(991234)
print(i)


# Przykład 11.
from bisect import bisect_left
i = bisect_left(x, 991234)
print(i)


# Przykład 12.
from timeit import timeit
print(timeit(
    'a.index(len(a)-1)',
    'a = list(range(100))',
    number=1000))
print(timeit(
    'bisect_left(a, len(a)-1)',
    'from bisect import bisect_left;'
    'a = list(range(10**6))',
    number=1000))
