#!/usr/bin/env python3

# Copyright 2014 Brett Slatkin, Pearson Education Inc.
#
# Udostępniono na licencji Apache w wersji 2.0 ("Licencja").
# Tego pliku można używać jedynie zgodnie z warunkami Licencji.
# Treść Licencji znajdziesz na stronie:
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# O ile obowiązujące prawo nie stanowi inaczej lub czegoś innego nie
# uzgodniono w formie pisemnej, oprogramowanie objęte Licencją jest
# dostarczane w stanie, w jakim jest (wersja "AS IS"), BEZ JAKIEJKOLWIEK
# GWARANCJI, ani wyrażonej otwarcie, ani domyślnej. Dokładne zasady
# i warunki Licencji znajdziesz w jej treści.

# Przygotowania mające na celu odtworzenie środowiska użytego w książce.
import logging
from pprint import pprint
from sys import stdout as STDOUT


# Przykład 1.
def trace(func):
    def wrapper(*args, **kwargs):
        result = func(*args, **kwargs)
        print('%s(%r, %r) -> %r' %
              (func.__name__, args, kwargs, result))
        return result
    return wrapper


# Przykład 2.
@trace
def fibonacci(n):
    """Wartość zwrotna to n-ta liczba ciągu Fibonacciego."""
    if n in (0, 1):
        return n
    return (fibonacci(n - 2) + fibonacci(n - 1))


# Przykład 3.
def fibonacci(n):
    """Wartość zwrotna to n-ta liczba ciągu Fibonacciego."""
    if n in (0, 1):
        return n
    return (fibonacci(n - 2) + fibonacci(n - 1))

fibonacci = trace(fibonacci)


# Przykład 4.
fibonacci(3)


# Przykład 5.
print(fibonacci)


# Przykład 6.
try:
    # Przykład nieudanego podejścia opartego na pickle.
    import pickle
    
    def my_func():
        return 1
    
    # To będzie działało.
    print(pickle.dumps(my_func))
    
    @trace
    def my_func2():
        return 2
    
    # To się nie uda.
    print(pickle.dumps(my_func2))
except:
    logging.exception('Oczekiwany')
else:
    assert False


# Przykład 7.
help(fibonacci)


# Przykład 8.
from functools import wraps
def trace(func):
    @wraps(func)
    def wrapper(*args, **kwargs):
        result = func(*args, **kwargs)
        print('%s(%r, %r) -> %r' %
              (func.__name__, args, kwargs, result))
        return result
    return wrapper

@trace
def fibonacci(n):
    """Wartość zwrotna to n-ta liczba ciągu Fibonacciego."""
    if n in (0, 1):
        return n
    return (fibonacci(n - 2) +
            fibonacci(n - 1))


# Przykład 9.
help(fibonacci)
