#!/usr/bin/env python3

# Copyright 2014 Brett Slatkin, Pearson Education Inc.
#
# Udostępniono na licencji Apache w wersji 2.0 ("Licencja").
# Tego pliku można używać jedynie zgodnie z warunkami Licencji.
# Treść Licencji znajdziesz na stronie:
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# O ile obowiązujące prawo nie stanowi inaczej lub czegoś innego nie
# uzgodniono w formie pisemnej, oprogramowanie objęte Licencją jest
# dostarczane w stanie, w jakim jest (wersja "AS IS"), BEZ JAKIEJKOLWIEK
# GWARANCJI, ani wyrażonej otwarcie, ani domyślnej. Dokładne zasady
# i warunki Licencji znajdziesz w jej treści.

# Przygotowania mające na celu odtworzenie środowiska użytego w książce.
import logging
from pprint import pprint
from sys import stdout as STDOUT


# Przykład 1.
def remainder(number, divisor):
    return number % divisor

assert remainder(20, 7) == 6


# Przykład 2.
remainder(20, 7)
remainder(20, divisor=7)
remainder(number=20, divisor=7)
remainder(divisor=7, number=20)


# Przykład 3.
try:
    # Ten kod się nie skompiluje.
    source = """remainder(number=20, 7)"""
    eval(source)
except:
    logging.exception('Oczekiwany')
else:
    assert False


# Przykład 4.
try:
    remainder(20, number=7)
except:
    logging.exception('Oczekiwany')
else:
    assert False


# Przykład 5.
def flow_rate(weight_diff, time_diff):
    return weight_diff / time_diff

weight_diff = 0.5
time_diff = 3
flow = flow_rate(weight_diff, time_diff)
print('%.3f kg na sekundę' % flow)


# Przykład 6.
def flow_rate(weight_diff, time_diff, period):
    return (weight_diff / time_diff) * period


# Przykład 7.
flow_per_second = flow_rate(weight_diff, time_diff, 1)


# Przykład 8.
def flow_rate(weight_diff, time_diff, period=1):
    return (weight_diff / time_diff) * period


# Przykład 9.
flow_per_second = flow_rate(weight_diff, time_diff)
flow_per_hour = flow_rate(weight_diff, time_diff, period=3600)


# Przykład 10.
def flow_rate(weight_diff, time_diff,
              period=1, units_per_kg=1):
    return ((weight_diff / units_per_kg) / time_diff) * period


# Przykład 11.
pounds_per_hour = flow_rate(weight_diff, time_diff,
                            period=3600, units_per_kg=2.2)
print(pounds_per_hour)


# Przykład 12.
pounds_per_hour = flow_rate(weight_diff, time_diff, 3600, 2.2)
print(pounds_per_hour)
