#!/usr/bin/env python3

# Copyright 2014 Brett Slatkin, Pearson Education Inc.
#
# Udostępniono na licencji Apache w wersji 2.0 ("Licencja").
# Tego pliku można używać jedynie zgodnie z warunkami Licencji.
# Treść Licencji znajdziesz na stronie:
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# O ile obowiązujące prawo nie stanowi inaczej lub czegoś innego nie
# uzgodniono w formie pisemnej, oprogramowanie objęte Licencją jest
# dostarczane w stanie, w jakim jest (wersja "AS IS"), BEZ JAKIEJKOLWIEK
# GWARANCJI, ani wyrażonej otwarcie, ani domyślnej. Dokładne zasady
# i warunki Licencji znajdziesz w jej treści.

# Przygotowania mające na celu odtworzenie środowiska użytego w książce.
import logging
from pprint import pprint
from sys import stdout as STDOUT


# Przykład 1.
a = ['a', 'b', 'c', 'd', 'e', 'f', 'g', 'h']
print('Pierwsze cztery: ', a[:4])
print('Ostatnie cztery: ', a[-4:])
print('Dwa środkowe:    ', a[3:-3])


# Przykład 2.
assert a[:5] == a[0:5]


# Przykład 3.
assert a[5:] == a[5:len(a)]


# Przykład 4.
print(a[:5])
print(a[:-1])
print(a[4:])
print(a[-3:])
print(a[2:5])
print(a[2:-1])
print(a[-3:-1])


# Przykład 5.
a[:]      # ['a', 'b', 'c', 'd', 'e', 'f', 'g', 'h']
a[:5]     # ['a', 'b', 'c', 'd', 'e']
a[:-1]    # ['a', 'b', 'c', 'd', 'e', 'f', 'g']
a[4:]     #                     ['e', 'f', 'g', 'h']
a[-3:]    #                          ['f', 'g', 'h']
a[2:5]    #           ['c', 'd', 'e']
a[2:-1]   #           ['c', 'd', 'e', 'f', 'g']
a[-3:-1]  #                          ['f', 'g']


# Przykład 6.
first_twenty_items = a[:20]
last_twenty_items = a[-20:]


# Przykład 7.
try:
    a[20]
except:
    logging.exception('Oczekiwany')
else:
    assert False


# Przykład 8.
b = a[4:]
print('Przed:     ', b)
b[1] = 99
print('Po:        ', b)
print('Bez zmian: ', a)


# Przykład 9.
print('Przed ', a)
a[2:7] = [99, 22, 14]
print('Po    ', a)


# Przykład 10.
b = a[:]
assert b == a and b is not a


# Przykład 11.
b = a
print('Przed', a)
a[:] = [101, 102, 103]
assert a is b           # Nadal ten sam obiekt listy.
print('Po   ', a)       # Teraz ma zupełnie inną zawartość.
