#!/usr/bin/env python3

# Copyright 2014 Brett Slatkin, Pearson Education Inc.
#
# Udostępniono na licencji Apache w wersji 2.0 ("Licencja").
# Tego pliku można używać jedynie zgodnie z warunkami Licencji.
# Treść Licencji znajdziesz na stronie:
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# O ile obowiązujące prawo nie stanowi inaczej lub czegoś innego nie
# uzgodniono w formie pisemnej, oprogramowanie objęte Licencją jest
# dostarczane w stanie, w jakim jest (wersja "AS IS"), BEZ JAKIEJKOLWIEK
# GWARANCJI, ani wyrażonej otwarcie, ani domyślnej. Dokładne zasady
# i warunki Licencji znajdziesz w jej treści.

# Przygotowania mające na celu odtworzenie środowiska użytego w książce.
import logging
from pprint import pprint
from sys import stdout as STDOUT


# Przykład 1.
def palindrome(word):
    """Zwraca wartość True, jeżeli podane słowo jest palindromem."""
    return word == word[::-1]

assert palindrome('tacocat')
assert not palindrome('banana')


# Przykład 2.
print(repr(palindrome.__doc__))


# Przykład 3.
"""Biblioteka do testowania słów pod kątem różnych konstrukcji językowych.

Sprawdzenie sposobu wzajemnego powiązania słów czasami może być trudne!
Za pomocą tego modułu można łatwo ustalić, kiedy analizowane słowa
mają specjalne właściwości.

Dostępne funkcje:
- palindrome: określa, czy słowo jest palindromem.
- check_anagram: określa, czy dwa słowa są anagramami.
...
"""


# Przykład 4.
class Player(object):
    """Przedstawia gracza w grze.

    Podklasy mogą nadpisywać metodę 'tick' w celu dostarczenia
    własnych animacji ruchu gracza, w zależności od siły gracza,
    aktualnego poziomu itd.

    Atrybuty publiczne:
    - power: dostępna siła (liczba zmiennoprzecinkowa od 0 do 1).
    - coins: monety znalezione na danym poziomie (liczba całkowita).
    """


# Przykład 5.
import itertools
def find_anagrams(word, dictionary):
    """Wyszukuje wszystkie anagramy dla słowa.

    Ta funkcja działa szybko tylko wtedy, jeżeli sprawdzany
    będzie kontener w postaci słownika. Jej działanie będzie
    wolne w przypadku sprawdzania listy, natomiast szybkie, gdy
    sprawdzany będzie zbiór.

    Argumenty:
        word: ciąg tekstowy słowa docelowego.
        dictionary: kontener wraz z wszystkimi ciągami tekstowymi,
            które są rzeczywistymi słowami.

    Wartość zwrotna:
        Lista znalezionych anagramów. Jeżeli żaden nie
        zostanie znaleziony, wartość zwrotna jest pusta.
    """
    permutations = itertools.permutations(word, len(word))
    possible = (''.join(x) for x in permutations)
    found = {word for word in possible if word in dictionary}
    return list(found)

assert find_anagrams('pancakes', ['scanpeak']) == ['scanpeak']
