#!/usr/bin/env python3

# Copyright 2014 Brett Slatkin, Pearson Education Inc.
#
# Udostępniono na licencji Apache w wersji 2.0 ("Licencja").
# Tego pliku można używać jedynie zgodnie z warunkami Licencji.
# Treść Licencji znajdziesz na stronie:
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# O ile obowiązujące prawo nie stanowi inaczej lub czegoś innego nie
# uzgodniono w formie pisemnej, oprogramowanie objęte Licencją jest
# dostarczane w stanie, w jakim jest (wersja "AS IS"), BEZ JAKIEJKOLWIEK
# GWARANCJI, ani wyrażonej otwarcie, ani domyślnej. Dokładne zasady
# i warunki Licencji znajdziesz w jej treści.

# Przygotowania mające na celu odtworzenie środowiska użytego w książce.
import logging
from pprint import pprint
from sys import stdout as STDOUT


# Przykład 1.
rate = 1.45
seconds = 3*60 + 42
cost = rate * seconds / 60
print(cost)


# Przykład 2.
print(round(cost, 2))


# Przykład 3.
rate = 0.05
seconds = 5
cost = rate * seconds / 60
print(cost)


# Przykład 4.
print(round(cost, 2))


# Przykład 5.
from decimal import Decimal
from decimal import ROUND_UP
rate = Decimal('1.45')
seconds = Decimal('222')  # 3*60 + 42
cost = rate * seconds / Decimal('60')
print(cost)


# Przykład 6.
rounded = cost.quantize(Decimal('0.01'), rounding=ROUND_UP)
print(rounded)


# Przykład 7.
rate = Decimal('0.05')
seconds = Decimal('5')
cost = rate * seconds / Decimal('60')
print(cost)


# Przykład 8.
rounded = cost.quantize(Decimal('0.01'), rounding=ROUND_UP)
print(rounded)
