#!/usr/bin/env python3

# Copyright 2014 Brett Slatkin, Pearson Education Inc.
#
# Udostępniono na licencji Apache w wersji 2.0 ("Licencja").
# Tego pliku można używać jedynie zgodnie z warunkami Licencji.
# Treść Licencji znajdziesz na stronie:
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# O ile obowiązujące prawo nie stanowi inaczej lub czegoś innego nie
# uzgodniono w formie pisemnej, oprogramowanie objęte Licencją jest
# dostarczane w stanie, w jakim jest (wersja "AS IS"), BEZ JAKIEJKOLWIEK
# GWARANCJI, ani wyrażonej otwarcie, ani domyślnej. Dokładne zasady
# i warunki Licencji znajdziesz w jej treści.

# Przygotowania mające na celu odtworzenie środowiska użytego w książce.
import logging
from pprint import pprint
from sys import stdout as STDOUT


# Przykład 1.
def safe_division(number, divisor, ignore_overflow,
                  ignore_zero_division):
    try:
        return number / divisor
    except OverflowError:
        if ignore_overflow:
            return 0
        else:
            raise
    except ZeroDivisionError:
        if ignore_zero_division:
            return float('inf')
        else:
            raise


# Przykład 2.
result = safe_division(1, 10**500, True, False)
print(result)


# Przykład 3.
result = safe_division(1, 0, False, True)
print(result)


# Przykład 4.
def safe_division_b(number, divisor,
                    ignore_overflow=False,
                    ignore_zero_division=False):
    try:
        return number / divisor
    except OverflowError:
        if ignore_overflow:
            return 0
        else:
            raise
    except ZeroDivisionError:
        if ignore_zero_division:
            return float('inf')
        else:
            raise


# Przykład 5.
safe_division_b(1, 10**500, ignore_overflow=True)
safe_division_b(1, 0, ignore_zero_division=True)


# Przykład 6.
safe_division_b(1, 10**500, True, False)


# Przykład 7.
def safe_division_c(number, divisor, *,
                    ignore_overflow=False,
                    ignore_zero_division=False):
    try:
        return number / divisor
    except OverflowError:
        if ignore_overflow:
            return 0
        else:
            raise
    except ZeroDivisionError:
        if ignore_zero_division:
            return float('inf')
        else:
            raise


# Przykład 8.
try:
    safe_division_c(1, 10**500, True, False)
except:
    logging.exception('Oczekiwany')
else:
    assert False


# Przykład 9.
safe_division_c(1, 0, ignore_zero_division=True)  # Brak wyjątku.
try:
    safe_division_c(1, 0)
    assert False
except ZeroDivisionError:
    pass  # Oczekiwane.


# Przykład 12.
# Tak naprawdę poniższy kod to nie Python 2! Próbuję przedstawić rozwiązanie,
# które będzie wyglądało jak kontynuacja przedstawionego wcześniej kodu Pythona 2.
def safe_division_d(number, divisor, **kwargs):
    ignore_overflow = kwargs.pop('ignore_overflow', False)
    ignore_zero_div = kwargs.pop('ignore_zero_division', False)
    if kwargs:
        raise TypeError('Nieoczekiwany **kwargs: %r' % kwargs)
    try:
        return number / divisor
    except OverflowError:
        if ignore_overflow:
            return 0
        else:
            raise
    except ZeroDivisionError:
        if ignore_zero_div:
            return float('inf')
        else:
            raise

safe_division_d(1, 10)
safe_division_d(1, 0, ignore_zero_division=True)
safe_division_d(1, 10**500, ignore_overflow=True)


# Przykład 13.
try:
    safe_division_d(1, 0, False, True)
except:
    logging.exception('Oczekiwany')
else:
    assert False


# Przykład 14.
try:
    safe_division_d(0, 0, unexpected=True)
except:
    logging.exception('Oczekiwany')
else:
    assert False
