// Eksport danych.
export var color = "czerwony";
export let name = "Nicholas";
export const magicNumber = 7;

// Eksport funkcji.
export function sum(num1, num2) {
    return num1 + num1;
}

// Eksport klasy.
export class Rectangle {
    constructor(length, width) {
        this.length = length;
        this.width = width;
    }
}

// Ta funkcja jest prywatna w module.
function subtract(num1, num2) {
    return num1 - num2;
}

// Zdefiniowanie funkcji…
function multiply(num1, num2) {
    return num1 * num2;
}

// …i późniejsze jej wyeksportowanie.
export multiply;


--


// Import po prostu jednego identyfikatora.
import { sum } from "./example.js";

console.log(sum(1, 2));     // 3.

sum = 1;                    // Następuje zgłoszenie błędu.


--


// Import wielu identyfikatorów.
import { sum, multiply, magicNumber } from "./example.js";
console.log(sum(1, magicNumber));       // 8.
console.log(multiply(1, 2));            // 2.


--


// Import wszystkich identyfikatorów.
import * as example from "./example.js";
console.log(example.sum(1,
        example.magicNumber));          // 8.
console.log(example.multiply(1, 2));    // 2.


--


import { sum } from "./example.js";
import { multiply } from "./example.js";
import { magicNumber } from "./example.js";


--


if (flag) {
    export flag;    // Błąd składni.
}


--


function tryImport() {
    import flag from "./example.js";    // Błąd składni.
}


--


export var name = "Nicholas";
export function setName(newName) {
    name = newName;
}


--


import { name, setName } from "./example.js";

console.log(name);       // "Nicholas".
setName("Greg");
console.log(name);       // "Greg".

name = "Nicholas";       // Następuje zgłoszenie błędu.


--


function sum(num1, num2) {
    return num1 + num2;
}

export { sum as add };


--


import { add as sum } from "./example.js";
console.log(typeof add);            // "undefined".
console.log(sum(1, 2));             // 3.


--


export default function(num1, num2) {
    return num1 + num2;
}


--


function sum(num1, num2) {
    return num1 + num2;
}

export default sum;


--


function sum(num1, num2) {
    return num1 + num2;
}

export { sum as default };


--


// Import wartości domyślnej.
import sum from "./example.js";

console.log(sum(1, 2));     // 3.


--


export let color = "czerwony";

export default function(num1, num2) {
    return num1 + num2;
}


--


import sum, { color } from "./example.js";

console.log(sum(1, 2));     // 3.
console.log(color);         // "czerwony".


--


import { default as sum, color } from "./example.js";

console.log(sum(1, 2));     // 3.
console.log(color);         // "czerwony".


--


import { sum } from "./example.js";
export { sum }


--


// Kod modułu bez poleceń eksportu lub importu.
Array.prototype.pushAll = function(items) {

    // Elementy muszą być tablicami.
    if (!Array.isArray(items)) {
        throw new TypeError("Argument musi być tablicą.");
    }

    // Użycie wbudowanej metody push() i operatora rozszczepiania.
    return this.push(...items);
};


--


import "./example.js";

let colors = ["czerwony", "zielony", "niebieski"];
let items = [];

items.pushAll(colors);


--


<!-- Wczytanie pliku modułu JavaScript. -->
<script type="module" src="module.js"></script>

<!-- Wczytanie osadzonego modułu. -->
<script type="module">

import { sum } from "./example.js";

let result = sum(1, 2);

</script>


--


<!-- Ten moduł zostanie wykonany jako pierwszy. -->
<script type="module" src="module1.js"></script>

<!-- Ten moduł zostanie wykonany jako drugi. -->
<script type="module">
import { sum } from "./example.js";

let result = sum(1, 2);
</script>

<!-- Ten moduł zostanie wykonany jako trzeci. -->
<script type="module" src="module2.js"></script>


--


<!-- Brak gwarancji, który z poniższych modułów zostanie wykonany jako pierwszy. -->
<script type="module" async src="module1.js"></script>
<script type="module" async src="module2.js"></script>


--


// Wczytanie pliku script.js jako skryptu.
let worker = new Worker("script.js");


--


// Wczytanie pliku module.js jako modułu.
let worker = new Worker("module.js", { type: "module" });


--


// Import z pliku https://www.example.com/modules/example1.js.
import { first } from "./example1.js";

// Import z pliku https://www.example.com/example2.js.
import { second } from "../example2.js";

// Import z pliku https://www.example.com/example3.js.
import { third } from "/example3.js";

// Import z pliku https://www2.example.com/example4.js.
import { fourth } from "https://www2.example.com/example4.js";


--


// Nieprawidłowy format, ponieważ nie rozpoczyna się od /, ./ lub ../.
import { first } from "example.js";

// Nieprawidłowy format, ponieważ nie rozpoczyna się od /, ./ lub ../.
import { second } from "example/index.js";
