let colors = ["czerwony", "zielony", "niebieski"];

console.log(colors.length);         // 3.

colors[3] = "czarny";

console.log(colors.length);         // 4.
console.log(colors[3]);             // "czarny".

colors.length = 2;

console.log(colors.length);         // 2.
console.log(colors[3]);             // undefined.
console.log(colors[2]);             // undefined.
console.log(colors[1]);             // "zielony".


--


let target = {};

let proxy = new Proxy(target, {});

proxy.name = "proxy";

console.log(proxy.name);        // "proxy".
console.log(target.name);       // "proxy".

target.name = "target";
console.log(proxy.name);        // "target".
console.log(target.name);       // "target".


--


let target = {
    name: "target"
};

let proxy = new Proxy(target, {
    set(trapTarget, key, value, receiver) {

        // Zignorowanie istniejących właściwości, aby nie wpływać na nie.
        if (!trapTarget.hasOwnProperty(key)) {
            if (isNaN(value)) {
                throw new TypeError("Właściwość musi być liczbą.");
            }
        }
        // Dodanie właściwości.
        return Reflect.set(trapTarget, key, value, receiver);
    }
});

// Dodanie nowej właściwości.
proxy.count = 1;
console.log(proxy.count);       // 1.
console.log(target.count);      // 1.

// Można przypisać do name, ponieważ ta właściwość już istnieje w obiekcie target.
proxy.name = "proxy";
console.log(proxy.name);        // "proxy".
console.log(target.name);       // "proxy".

// Następuje zgłoszenie błędu.
proxy.anotherName = "proxy";


--


let target = {};

console.log(target.name);       // undefined.


--


let proxy = new Proxy({}, {
    get(trapTarget, key, receiver) {
        if (!(key in receiver)) {
            throw new TypeError("Właściwość " + key + " nie istnieje.");
        }
        return Reflect.get(trapTarget, key, receiver);
    }
});

// Dodanie właściwości nadal jest możliwe.
proxy.name = "proxy";
console.log(proxy.name);            // "proxy".

// Próba dostępu do nieistniejącej właściwości powoduje zgłoszenie błędu.
console.log(proxy.nme);             // Następuje zgłoszenie błędu.


--


let target = {
    value: 42;
}

console.log("value" in target);     // Wartość true.
console.log("toString" in target);  // Wartość true.


--


let target = {
    name: "target",
    value: 42
};
let proxy = new Proxy(target, {
    has(trapTarget, key) {

        if (key === "value") {
            return false;
        } else {
            return Reflect.has(trapTarget, key);
        }
    }
});

console.log("value" in proxy);      // Wartość false.
console.log("name" in proxy);       // Wartość true.
console.log("toString" in proxy);   // Wartość true.


--


let target = {
    name: "target",
    value: 42
};

Object.defineProperty(target, "name", { configurable: false });

console.log("value" in target);     // Wartość true.

let result1 = delete target.value;
console.log(result1);               // Wartość true.

console.log("value" in target);     // Wartość false.

// Uwaga: poniższy wiersz kodu w trybie ścisłym spowoduje zgłoszenie błędu.
let result2 = delete target.name;
console.log(result2);               // Wartość false.

console.log("name" in target);      // Wartość true.


--


let target = {
    name: "target",
    value: 42
};

let proxy = new Proxy(target, {
    deleteProperty(trapTarget, key) {

        if (key === "value") {
            return false;
        } else {
            return Reflect.deleteProperty(trapTarget, key);
        }
    }
});

// Próba usunięcia właściwości proxy.value.

console.log("value" in proxy);      // Wartość true.

let result1 = delete proxy.value;
console.log(result1);               // Wartość false.

console.log("value" in proxy);      // Wartość true.

// Próba usunięcia właściwości proxy.name.

console.log("name" in proxy);       // Wartość true.

let result2 = delete proxy.name;
console.log(result2);               // Wartość true.

console.log("name" in proxy);       // Wartość false.


--


let target = {};
let proxy = new Proxy(target, {
    getPrototypeOf(trapTarget) {
        return null;
    },
    setPrototypeOf(trapTarget, proto) {
        return false;
    }
});
let targetProto = Object.getPrototypeOf(target);
let proxyProto = Object.getPrototypeOf(proxy);

console.log(targetProto === Object.prototype);      // Wartość true.
console.log(proxyProto === Object.prototype);       // Wartość false.
console.log(proxyProto);                            // Wartość null.

// Operacja zakończyła się sukcesem.
Object.setPrototypeOf(target, {});

// Następuje zgłoszenie błędu.
Object.setPrototypeOf(proxy, {});


--


let target = {};
let proxy = new Proxy(target, {
    getPrototypeOf(trapTarget) {
        return Reflect.getPrototypeOf(trapTarget);
    },
    setPrototypeOf(trapTarget, proto) {
        return Reflect.setPrototypeOf(trapTarget, proto);
    }
});

let targetProto = Object.getPrototypeOf(target);
let proxyProto = Object.getPrototypeOf(proxy);

console.log(targetProto === Object.prototype);      // Wartość true.
console.log(proxyProto === Object.prototype);       // Wartość true.

// Operacja zakończyła się sukcesem.
Object.setPrototypeOf(target, {});

// Ta operacja również zakończyła się sukcesem.
Object.setPrototypeOf(proxy, {});


--


let result1 = Object.getPrototypeOf(1);
console.log(result1 === Number.prototype);  // Wartość true.

// Następuje zgłoszenie błędu.
Reflect.getPrototypeOf(1);


--


let target1 = {};
let result1 = Object.setPrototypeOf(target1, {});
console.log(result1 === target1);                   // Wartość true.

let target2 = {};
let result2 = Reflect.setPrototypeOf(target2, {});
console.log(result2 === target2);                   // Wartość false.
console.log(result2);                               // Wartość true.


--


let target = {};
let proxy = new Proxy(target, {
    isExtensible(trapTarget) {
        return Reflect.isExtensible(trapTarget);
    },
    preventExtensions(trapTarget) {
        return Reflect.preventExtensions(trapTarget);
    }
});

console.log(Object.isExtensible(target));       // Wartość true.
console.log(Object.isExtensible(proxy));        // Wartość true.

Object.preventExtensions(proxy);

console.log(Object.isExtensible(target));       // Wartość false.
console.log(Object.isExtensible(proxy));        // Wartość false.


--


let target = {};
let proxy = new Proxy(target, {
    isExtensible(trapTarget) {
        return Reflect.isExtensible(trapTarget);
    },
    preventExtensions(trapTarget) {
        return false
    }
});

console.log(Object.isExtensible(target));       // Wartość true.
console.log(Object.isExtensible(proxy));        // Wartość true.

Object.preventExtensions(proxy);

console.log(Object.isExtensible(target));       // Wartość true.
console.log(Object.isExtensible(proxy));        // Wartość true.


--


let result1 = Object.isExtensible(2);
console.log(result1);                       // Wartość false.

// Następuje zgłoszenie błędu.
let result2 = Reflect.isExtensible(2);


--


let result1 = Object.preventExtensions(2);
console.log(result1);                               // 2.

let target = {};
let result2 = Reflect.preventExtensions(target);
console.log(result2);                               // Wartość true.

// Następuje zgłoszenie błędu.
let result3 = Reflect.preventExtensions(2);


--


let proxy = new Proxy({}, {
    defineProperty(trapTarget, key, descriptor) {
        return Reflect.defineProperty(trapTarget, key, descriptor);
    },
    getOwnPropertyDescriptor(trapTarget, key) {
        return Reflect.getOwnPropertyDescriptor(trapTarget, key);
    }
});

Object.defineProperty(proxy, "name", {
    value: "proxy"
});

console.log(proxy.name);            // "proxy".

let descriptor = Object.getOwnPropertyDescriptor(proxy, "name");

console.log(descriptor.value);      // "proxy".


--


let proxy = new Proxy({}, {
    defineProperty(trapTarget, key, descriptor) {

        if (typeof key === "symbol") {
            return false;
        }

        return Reflect.defineProperty(trapTarget, key, descriptor);
    }
});

Object.defineProperty(proxy, "name", {
    value: "proxy"
});

console.log(proxy.name);                    // "proxy".

let nameSymbol = Symbol("name");
// Następuje zgłoszenie błędu.
Object.defineProperty(proxy, nameSymbol, {
    value: "proxy"
});


--


let proxy = new Proxy({}, {
    defineProperty(trapTarget, key, descriptor) {
        console.log(descriptor.value);              // "proxy".
        console.log(descriptor.name);               // undefined.

        return Reflect.defineProperty(trapTarget, key, descriptor);
    }
});

Object.defineProperty(proxy, "name", {
    value: "proxy",
    name: "custom"
});


--


let proxy = new Proxy({}, {
    getOwnPropertyDescriptor(trapTarget, key) {
        return {
            name: "proxy";
        };
    }
});

// Następuje zgłoszenie błędu.
let descriptor = Object.getOwnPropertyDescriptor(proxy, "name");


--


let target = {};

let result1 = Object.defineProperty(target, "name", { value: "target "});

console.log(target === result1);        // Wartość true.

let result2 = Reflect.defineProperty(target, "name", { value: "reflect" });

console.log(result2);                   // Wartość true.


--


let descriptor1 = Object.getOwnPropertyDescriptor(2, "name");
console.log(descriptor1);       // undefined.

// Następuje zgłoszenie błędu.
let descriptor2 = Reflect.getOwnPropertyDescriptor(2, "name");


--


let proxy = new Proxy({}, {
    ownKeys(trapTarget) {
        return Reflect.ownKeys(trapTarget).filter(key => {
            return typeof key !== "string" || key[0] !== "_";
        });
    }
});

let nameSymbol = Symbol("name");

proxy.name = "proxy";
proxy._name = "private";
proxy[nameSymbol] = "symbol";

let names = Object.getOwnPropertyNames(proxy),
    keys = Object.keys(proxy),
    symbols = Object.getOwnPropertySymbols(proxy);

console.log(names.length);      // 1.
console.log(names[0]);          // "proxy".

console.log(keys.length);       // 1.
console.log(keys[0]);           // "proxy".

console.log(symbols.length);    // 1.
console.log(symbols[0]);        // "Symbol(name)".


--


let target = function() { return 42 },
    proxy = new Proxy(target, {
        apply: function(trapTarget, thisArg, argumentsList) {
            return Reflect.apply(trapTarget, thisArg, argumentsList);
        },
        construct: function(trapTarget, argumentsList) {
            return Reflect.construct(trapTarget, argumentsList);
        }
    });

// Proxy wraz z funkcją jako jej obiektem docelowym.
console.log(typeof proxy);                  // "function".

console.log(proxy());                       // 42.

var instance = new proxy();
console.log(instance instanceof proxy);     // Wartość true.
console.log(instance instanceof target);    // Wartość true.


--


// Dodanie do siebie wszystkich argumentów.
function sum(...values) {
    return values.reduce((previous, current) => previous + current, 0);
}

let sumProxy = new Proxy(sum, {
    apply: function(trapTarget, thisArg, argumentsList) {

        argumentsList.forEach((arg) => {
            if (typeof arg !== "number") {
                throw new TypeError("Wszystkie argumenty muszą być liczbami.");
            }
        });

        return Reflect.apply(trapTarget, thisArg, argumentsList);
    },
    construct: function(trapTarget, argumentsList) {
        throw new TypeError("Ta funkcja nie może być wywołana wraz z operatorem new.");
    }
});

console.log(sumProxy(1, 2, 3, 4));          // 10.

// Następuje zgłoszenie błędu.
console.log(sumProxy(1, "2", 3, 4));

// Tutaj również następuje zgłoszenie błędu.
let result = new sumProxy();


--


function Numbers(...values) {
    this.values = values;
}
let NumbersProxy = new Proxy(Numbers, {
    apply: function(trapTarget, thisArg, argumentsList) {
        throw new TypeError("Ta funkcja musi być wywołana wraz z operatorem new.");
    },

    construct: function(trapTarget, argumentsList) {
        argumentsList.forEach((arg) => {
            if (typeof arg !== "number") {
                throw new TypeError("Wszystkie argumenty muszą być liczbami.");
            }
        });
        return Reflect.construct(trapTarget, argumentsList);
    }
});

let instance = new NumbersProxy(1, 2, 3, 4);
console.log(instance.values);               // [1,2,3,4].

// Następuje zgłoszenie błędu.
NumbersProxy(1, 2, 3, 4);


--


function Numbers(...values) {

    if (typeof new.target === "undefined") {
        throw new TypeError("Ta funkcja musi być wywołana wraz z operatorem new.");
    }
    this.values = values;
}

let instance = new Numbers(1, 2, 3, 4);
console.log(instance.values);               // [1,2,3,4].

// Następuje zgłoszenie błędu.
Numbers(1, 2, 3, 4);


--


function Numbers(...values) {

    if (typeof new.target === "undefined") {
        throw new TypeError("Ta funkcja musi być wywołana wraz z operatorem new.");
    }

    this.values = values;
}

let NumbersProxy = new Proxy(Numbers, {
    apply: function(trapTarget, thisArg, argumentsList) {
        return Reflect.construct(trapTarget, argumentsList);
    }
});

let instance = NumbersProxy(1, 2, 3, 4);
console.log(instance.values);               // [1,2,3,4].


--


class AbstractNumbers {

    constructor(...values) {
        if (new.target === AbstractNumbers) {
            throw new TypeError("Ta funkcja musi być dziedziczona.");
        }

        this.values = values;
    }
}

class Numbers extends AbstractNumbers {}

let instance = new Numbers(1, 2, 3, 4);
console.log(instance.values);           // [1,2,3,4].

// Następuje zgłoszenie błędu.
new AbstractNumbers(1, 2, 3, 4);


--


class AbstractNumbers {

    constructor(...values) {
        if (new.target === AbstractNumbers) {
            throw new TypeError("Ta funkcja musi być dziedziczona.");
        }

        this.values = values;
    }
}

let AbstractNumbersProxy = new Proxy(AbstractNumbers, {
    construct: function(trapTarget, argumentsList) {
        return Reflect.construct(trapTarget, argumentsList, function() {});
    }
});

let instance = new AbstractNumbersProxy(1, 2, 3, 4);
console.log(instance.values);               // [1,2,3,4].


--


class Person {
    constructor(name) {
        this.name = name;
    }
}

let PersonProxy = new Proxy(Person, {
    apply: function(trapTarget, thisArg, argumentsList) {
        return new trapTarget(...argumentsList);
    }
});

let me = PersonProxy("Nicholas");
console.log(me.name);                   // "Nicholas".
console.log(me instanceof Person);      // Wartość true.
console.log(me instanceof PersonProxy); // Wartość true.


--


let target = {
    name: "target"
};

let { proxy, revoke } = Proxy.revocable(target, {});

console.log(proxy.name);        // "target".

revoke();

// Następuje zgłoszenie błędu.
console.log(proxy.name);


--


let colors = ["czerwony", "zielony", "niebieski"];

console.log(colors.length);         // 3.

colors[3] = "czarny";

console.log(colors.length);         // 4.
console.log(colors[3]);             // "czarny".

colors.length = 2;

console.log(colors.length);         // 2.
console.log(colors[3]);             // undefined.
console.log(colors[2]);             // undefined.
console.log(colors[1]);             // "zielony".


--


function toUint32(value) {
    return Math.floor(Math.abs(Number(value))) % Math.pow(2, 32);
}

function isArrayIndex(key) {
    let numericKey = toUint32(key);
    return String(numericKey) == key && numericKey < (Math.pow(2, 32) - 1);
}


--


function toUint32(value) {
    return Math.floor(Math.abs(Number(value))) % Math.pow(2, 32);
}
function isArrayIndex(key) {
    let numericKey = toUint32(key);
    return String(numericKey) == key && numericKey < (Math.pow(2, 32) - 1);
}

function createMyArray(length=0) {
    return new Proxy({ length }, {
        set(trapTarget, key, value) {

            let currentLength = Reflect.get(trapTarget, "length");

            // Przypadek specjalny.
            if (isArrayIndex(key)) {
                let numericKey = Number(key);

                if (numericKey >= currentLength) {
                    Reflect.set(trapTarget, "length", numericKey + 1);
                }
            }

            // Tę operację wykonujemy zawsze niezależnie od typu klucza.
            return Reflect.set(trapTarget, key, value);
        }
    });
}

let colors = createMyArray(3);
console.log(colors.length);         // 3.

colors[0] = "czerwony";
colors[1] = "zielony";
colors[2] = "niebieski";

console.log(colors.length);         // 3.

colors[3] = "czarny";

console.log(colors.length);         // 4.
console.log(colors[3]);             // "czarny".


--


function toUint32(value) {
    return Math.floor(Math.abs(Number(value))) % Math.pow(2, 32);
}

function isArrayIndex(key) {
    let numericKey = toUint32(key);
    return String(numericKey) == key && numericKey < (Math.pow(2, 32) - 1);
}

function createMyArray(length=0) {
    return new Proxy({ length }, {
        set(trapTarget, key, value) {

            let currentLength = Reflect.get(trapTarget, "length");

            // Przypadek specjalny.
            if (isArrayIndex(key)) {
                let numericKey = Number(key);

                if (numericKey >= currentLength) {
                    Reflect.set(trapTarget, "length", numericKey + 1);
                }
            } else if (key === "length") {

                if (value < currentLength) {
                    for (let index = currentLength - 1; index >= value; 
                            index--) {
                        Reflect.deleteProperty(trapTarget, index);
                    }
                }
            }

            // Tę operację wykonujemy zawsze niezależnie od typu klucza.
            return Reflect.set(trapTarget, key, value);
        }
    });
}

let colors = createMyArray(3);
console.log(colors.length);         // 3.
colors[0] = "czerwony";
colors[1] = "zielony";
colors[2] = "niebieski";
colors[3] = "czarny";

console.log(colors.length);         // 4.

colors.length = 2;

console.log(colors.length);         // 2.
console.log(colors[3]);             // undefined.
console.log(colors[2]);             // undefined.
console.log(colors[1]);             // "zielony".
console.log(colors[0]);             // "czerwony".


--


class Thing {
    constructor() {
        return new Proxy(this, {});
    }
}

let myThing = new Thing();
console.log(myThing instanceof Thing);      // Wartość true.


--


function toUint32(value) {
    return Math.floor(Math.abs(Number(value))) % Math.pow(2, 32);
}

function isArrayIndex(key) {
    let numericKey = toUint32(key);
    return String(numericKey) == key && numericKey < (Math.pow(2, 32) - 1);
}

class MyArray {
    constructor(length=0) {
        this.length = length;

        return new Proxy(this, {
            set(trapTarget, key, value) {

                let currentLength = Reflect.get(trapTarget, "length");

                // Przypadek specjalny.
                if (isArrayIndex(key)) {
                    let numericKey = Number(key);

                    if (numericKey >= currentLength) {
                        Reflect.set(trapTarget, "length", numericKey + 1);
                    }
                } else if (key === "length") {

                    if (value < currentLength) {
                        for (let index = currentLength - 1; index >= value;
                               index--) {
                            Reflect.deleteProperty(trapTarget, index);
                        }
                    }
                }
                // Tę operację wykonujemy zawsze niezależnie od typu klucza.
                return Reflect.set(trapTarget, key, value);
            }
        });
    }
}

let colors = new MyArray(3);
console.log(colors instanceof MyArray);     // Wartość true.

console.log(colors.length);         // 3.

colors[0] = "czerwony";
colors[1] = "zielony";
colors[2] = "niebieski";
colors[3] = "czarny";

console.log(colors.length);         // 4.

colors.length = 2;

console.log(colors.length);         // 2.
console.log(colors[3]);             // undefined.
console.log(colors[2]);             // undefined.
console.log(colors[1]);             // "zielony".
console.log(colors[0]);             // "czerwony".


--


let target = {};
let newTarget = Object.create(new Proxy(target, {

    // Poniższa metoda nigdy nie będzie wywołana.
    defineProperty(trapTarget, name, descriptor) {

        // W przypadku wywołania nastąpi zgłoszenie błędu.
        return false;
    }
}));

Object.defineProperty(newTarget, "name", {
    value: "newTarget"
});

console.log(newTarget.name);                    // "newTarget".
console.log(newTarget.hasOwnProperty("name"));  // Wartość true.


--


let target = {};
let thing = Object.create(new Proxy(target, {
    get(trapTarget, key, receiver) {
        throw new ReferenceError(`${key} nie istnieje.`);
    }
}));

thing.name = "thing";
console.log(thing.name);        // "thing".

// Następuje zgłoszenie błędu.
let unknown = thing.unknown;


--


let target = {};
let thing = Object.create(new Proxy(target, {
    set(trapTarget, key, value, receiver) {
        return Reflect.set(trapTarget, key, value, receiver);
    }
}));

console.log(thing.hasOwnProperty("name"));      // Wartość false.

// Wywołanie pułapki `set` w proxy.
thing.name = "thing";

console.log(thing.name);                        // "thing".
console.log(thing.hasOwnProperty("name"));      // Wartość true.

// Brak wywołania pułapki `set` w proxy.
thing.name = "boo";

console.log(thing.name);                        // "boo".


--


let target = {};
let thing = Object.create(new Proxy(target, {
    has(trapTarget, key) {
        return Reflect.has(trapTarget, key);
    }
}));

// Wywołanie pułapki `has` w proxy.
console.log("name" in thing);                   // Wartość false.

thing.name = "thing";

// Brak wywołania pułapki `has` w proxy.
console.log("name" in thing);                   // Wartość true.


--


function NoSuchProperty() {
    // Pusta definicja funkcji.
}

NoSuchProperty.prototype = new Proxy({}, {
    get(trapTarget, key, receiver) {
        throw new ReferenceError(`${key} nie istnieje.`);
    }
});

let thing = new NoSuchProperty();

// Następuje zgłoszenie błędu ze względu na pułapkę `get` w proxy.
let result = thing.name;


--


function NoSuchProperty() {
    // Pusta definicja funkcji.
}

NoSuchProperty.prototype = new Proxy({}, {
    get(trapTarget, key, receiver) {
        throw new ReferenceError(`${key} nie istnieje.`);
    }
});
class Square extends NoSuchProperty {
    constructor(length, width) {
        super();
        this.length = length;
        this.width = width;
    }
}

let shape = new Square(2, 6);

let area1 = shape.length * shape.width;
console.log(area1);                         // 12.

// Następuje zgłoszenie błędu, ponieważ "wdth" nie istnieje.
let area2 = shape.length * shape.wdth;


--


function NoSuchProperty() {
    // Pusta definicja funkcji.
}

// Przechowywanie odwołania do proxy, które będzie prototypem.
let proxy = new Proxy({}, {
    get(trapTarget, key, receiver) {
        throw new ReferenceError(`${key} nie istnieje.`);
    }
});

NoSuchProperty.prototype = proxy;

class Square extends NoSuchProperty {
    constructor(length, width) {
        super();
        this.length = length;
        this.width = width;
    }
}

let shape = new Square(2, 6);

let shapeProto = Object.getPrototypeOf(shape);
console.log(shapeProto === proxy);                  // Wartość false.

let secondLevelProto = Object.getPrototypeOf(shapeProto);

console.log(secondLevelProto === proxy);            // Wartość true.


--


function NoSuchProperty() {
    // Pusta definicja funkcji.
}

NoSuchProperty.prototype = new Proxy({}, {
    get(trapTarget, key, receiver) {
        throw new ReferenceError(`${key} nie istnieje.`);
    }
});

class Square extends NoSuchProperty {
    constructor(length, width) {
        super();
        this.length = length;
        this.width = width;
    }

    getArea() {
        return this.length * this.width;
    }
}

let shape = new Square(2, 6);

let area1 = shape.length * shape.width;
console.log(area1);                         // 12.

let area2 = shape.getArea();
console.log(area2);                         // 12.

// Następuje zgłoszenie błędu, ponieważ "wdth" nie istnieje.
let area3 = shape.length * shape.wdth;
