let button = document.getElementById("my-btn");
button.onclick = function(event) {
    console.log("Kliknięto przycisk.");
};


--


readFile("example.txt", function(err, contents) {
    if (err) {
        throw err;
    }

    console.log(contents);
});

console.log("Cześć!");


--


readFile("example.txt", function(err, contents) {
    if (err) {
        throw err;
    }

    writeFile("example.txt", function(err) {
        if (err) {
            throw err;
        }

        console.log("Plik został zapisany!");
    });
});


--


method1(function(err, result) {

    if (err) {
        throw err;
    }

    method2(function(err, result) {

        if (err) {
            throw err;
        }

        method3(function(err, result) {

            if (err) {
                throw err;
            }

            method4(function(err, result) {

                if (err) {
                    throw err;
                }

                method5(result);
            });

        });

    });

});


--


// Funkcja readFile() obiecuje zakończyć działanie w pewnym momencie w przyszłości.
let promise = readFile("example.txt");


--


let promise = readFile("example.txt");

promise.then(function(contents) {
    // Spełnienie obietnicy.
    console.log(contents);
}, function(err) {
    // Odrzucenie obietnicy.
    console.error(err.message);
});

promise.then(function(contents) {
    // Spełnienie obietnicy.
    console.log(contents);
});

promise.then(null, function(err) {
    // Odrzucenie obietnicy.
    console.error(err.message);
});


--


promise.catch(function(err) {
    // Odrzucenie obietnicy.
    console.error(err.message);
});

// Powyższe wywołanie odpowiada poniższemu.

promise.then(null, function(err) {
    // Odrzucenie obietnicy.
    console.error(err.message);
});


--


let promise = readFile("example.txt");

// Pierwotna procedura obsługi spełnienia obietnicy.
promise.then(function(contents) {
    console.log(contents);

    // Dodana później procedura obsługi.
    promise.then(function(contents) {
        console.log(contents);
    });
});


--


// Przykład oparty na Node.js.

let fs = require("fs");

function readFile(filename) {
    return new Promise(function(resolve, reject) {
        // Wywołanie operacji asynchronicznej.
        fs.readFile(filename, { encoding: "utf8" }, function(err, contents) {

            // Sprawdzenie pod kątem błędów.
            if (err) {
                reject(err);
                return;
            }

            // Operacja odczytu zakończyła się sukcesem.
            resolve(contents);

        });
    });
}

let promise = readFile("example.txt");

// Nasłuchiwanie zarówno spełnienia, jak i odrzucenia obietnicy.
promise.then(function(contents) {
    // Spełnienie obietnicy.
    console.log(contents);
}, function(err) {
    // Odrzucenie obietnicy.
    console.error(err.message);
});


--


// Dodanie tej funkcji do kolekcji zadań po upływie 500 ms.
setTimeout(function() {
    console.log("Minęła zdefiniowana ilość czasu.");
}, 500);

console.log("Cześć!");


--


let promise = new Promise(function(resolve, reject) {
    console.log("Obietnica.");
    resolve();
});

console.log("Cześć!");


--


let promise = new Promise(function(resolve, reject) {
    console.log("Obietnica.");
    resolve();
});

promise.then(function() {
    console.log("Rozstrzygnięta obietnica.");
});

console.log("Cześć!");


--


let promise = Promise.resolve(42);

promise.then(function(value) {
    console.log(value);         // 42
});


--


let promise = Promise.reject(42);

promise.catch(function(value) {
    console.log(value);         // 42
});


--


let thenable = {
    then: function(resolve, reject) {
        resolve(42);
    }
};


--


let thenable = {
    then: function(resolve, reject) {
        resolve(42);
    }
};

let p1 = Promise.resolve(thenable);
p1.then(function(value) {
    console.log(value);     // 42
});


--


let thenable = {
    then: function(resolve, reject) {
        reject(42);
    }
};

let p1 = Promise.resolve(thenable);
p1.catch(function(value) {
    console.log(value);     // 42
});


--


let promise = new Promise(function(resolve, reject) {
    throw new Error("Wybuch!");
});

promise.catch(function(error) {
    console.log(error.message);     // "Wybuch!".
});


--


let promise = new Promise(function(resolve, reject) {
    try {
        throw new Error("Wybuch!");
    } catch (ex) {
        reject(ex);
    }
});

promise.catch(function(error) {
    console.log(error.message);     // "Wybuch!".
});


--


let rejected = Promise.reject(42);

// Na tym etapie odrzucenie obietnicy nie zostało obsłużone.

// Nieco później…
rejected.catch(function(value) {
    // Teraz odrzucenie obietnicy zostało obsłużone.
    console.log(value);
});


--


let rejected;

process.on("unhandledRejection", function(reason, promise) {
    console.log(reason.message);            // "Wybuch!".
    console.log(rejected === promise);      // Wartość true.
});

rejected = Promise.reject(new Error("Wybuch!"));


--


let rejected;

process.on("rejectionHandled", function(promise) {
    console.log(rejected === promise);      // Wartość true.
});

rejected = Promise.reject(new Error("Wybuch!"));

// Czekamy z dodaniem procedury obsługi odrzucenia obietnicy.
setTimeout(function() {
    rejected.catch(function(value) {
        console.log(value.message);         // "Wybuch!".
    });
}, 1000);


--


let possiblyUnhandledRejections = new Map();

// Kiedy odrzucenie obietnicy nie zostało obsłużone, dodajemy je do mapy.
process.on("unhandledRejection", function(reason, promise) {
    possiblyUnhandledRejections.set(promise, reason);
});

process.on("rejectionHandled", function(promise) {
    possiblyUnhandledRejections.delete(promise);
});

setInterval(function() {

    possiblyUnhandledRejections.forEach(function(reason, promise) {
        console.log(reason.message ? reason.message : reason);

        // Wykonanie pewnych działań w celu obsłużenia tych odrzuceń obietnic.
        handleRejection(promise, reason);
    });

    possiblyUnhandledRejections.clear();

}, 60000);


--


let rejected;

window.onunhandledrejection = function(event) {
    console.log(event.type);                    // "unhandledrejection".
    console.log(event.reason.message);          // "Wybuch!".
    console.log(rejected === event.promise);    // Wartość true.
});

window.onrejectionhandled = function(event) {
    console.log(event.type);                    // "rejectionhandled".
    console.log(event.reason.message);          // "Wybuch!".
    console.log(rejected === event.promise);    // Wartość true.
});

rejected = Promise.reject(new Error("Wybuch!"));


--


let possiblyUnhandledRejections = new Map();

// Kiedy odrzucenie obietnicy nie zostało obsłużone, dodajemy je do mapy.
window.onunhandledrejection = function(event) {
    possiblyUnhandledRejections.set(event.promise, event.reason);
};

window.onrejectionhandled = function(event) {
    possiblyUnhandledRejections.delete(event.promise);
};

setInterval(function() {

    possiblyUnhandledRejections.forEach(function(reason, promise) {
        console.log(reason.message ? reason.message : reason);

        // Wykonanie pewnych działań w celu obsłużenia tych odrzuceń obietnic.
        handleRejection(promise, reason);
    });

    possiblyUnhandledRejections.clear();

}, 60000);


--


let p1 = new Promise(function(resolve, reject) {
    resolve(42);
});
p1.then(function(value) {
    console.log(value);
}).then(function() {
    console.log("Koniec!");
});


--


let p1 = new Promise(function(resolve, reject) {
    resolve(42);
});

let p2 = p1.then(function(value) {
    console.log(value);
})

p2.then(function() {
    console.log("Koniec!");
});


--


let p1 = new Promise(function(resolve, reject) {
    resolve(42);
});

p1.then(function(value) {
    throw new Error("Wybuch!");
}).catch(function(error) {
    console.log(error.message);     // "Wybuch!".
});


--


let p1 = new Promise(function(resolve, reject) {
    throw new Error("Wybuch!");
});

p1.catch(function(error) {
    console.log(error.message);     // "Wybuch!".
    throw new Error("Wybuch!");
}).catch(function(error) {
    console.log(error.message);     // "Wybuch!".
});


--


let p1 = new Promise(function(resolve, reject) {
    resolve(42);
});

p1.then(function(value) {
    console.log(value);         // "42".
    return value + 1;
}).then(function(value) {
    console.log(value);         // "43".
});


--


let p1 = new Promise(function(resolve, reject) {
    reject(42);
});

p1.catch(function(value) {
    // Pierwsza procedura obsługi spełnienia obietnicy.
    console.log(value);         // "42".
    return value + 1;
}).then(function(value) {
    // Druga procedura obsługi spełnienia obietnicy.
    console.log(value);         // "43".
});


--


let p1 = new Promise(function(resolve, reject) {
    resolve(42);
});

let p2 = new Promise(function(resolve, reject) {
    resolve(43);
});

p1.then(function(value) {
    // Pierwsza procedura obsługi spełnienia obietnicy.
    console.log(value);     // 42.
    return p2;
}).then(function(value) {
    // Druga procedura obsługi spełnienia obietnicy.
    console.log(value);     // 43.
});


--


let p1 = new Promise(function(resolve, reject) {
    resolve(42);
});

let p2 = new Promise(function(resolve, reject) {
    resolve(43);
});

let p3 = p1.then(function(value) {
    // Pierwsza procedura obsługi spełnienia obietnicy.
    console.log(value);     // 42.
    return p2;
});
p3.then(function(value) {
    // Druga procedura obsługi spełnienia obietnicy.
    console.log(value);     // 43.
});


--


let p1 = new Promise(function(resolve, reject) {
    resolve(42);
});

let p2 = new Promise(function(resolve, reject) {
    reject(43);
});

p1.then(function(value) {
    // Pierwsza procedura obsługi spełnienia obietnicy.
    console.log(value);     // 42.
    return p2;
}).then(function(value) {
    // Druga procedura obsługi spełnienia obietnicy.
    console.log(value);     // To polecenie nigdy nie zostanie wywołane.
});


--


let p1 = new Promise(function(resolve, reject) {
    resolve(42);
});

let p2 = new Promise(function(resolve, reject) {
    reject(43);
});

p1.then(function(value) {
    // Pierwsza procedura obsługi spełnienia obietnicy.
    console.log(value);     // 42.
    return p2;
}).catch(function(value) {
    // Procedura obsługi odrzucenia obietnicy.
    console.log(value);     // 43.
});


--


let p1 = new Promise(function(resolve, reject) {
    resolve(42);
});

p1.then(function(value) {
    console.log(value);     // 42.

    // Utworzenie nowej obietnicy.
    let p2 = new Promise(function(resolve, reject) {
        resolve(43);
    });

    return p2
}).then(function(value) {
    console.log(value);     // 43.
});


--


let p1 = new Promise(function(resolve, reject) {
    resolve(42);
});

let p2 = new Promise(function(resolve, reject) {
    resolve(43);
});

let p3 = new Promise(function(resolve, reject) {
    resolve(44);
});

let p4 = Promise.all([p1, p2, p3]);

p4.then(function(value) {
    console.log(Array.isArray(value));  // Wartość true.
    console.log(value[0]);              // 42.
    console.log(value[1]);              // 43.
    console.log(value[2]);              // 44.
});


--


let p1 = new Promise(function(resolve, reject) {
    resolve(42);
});

let p2 = new Promise(function(resolve, reject) {
    reject(43);
});

let p3 = new Promise(function(resolve, reject) {
    resolve(44);
});

let p4 = Promise.all([p1, p2, p3]);
p4.catch(function(value) {
    console.log(Array.isArray(value))   // Wartość false.
    console.log(value);                 // 43.
});


--


let p1 = Promise.resolve(42);

let p2 = new Promise(function(resolve, reject) {
    resolve(43);
});

let p3 = new Promise(function(resolve, reject) {
    resolve(44);
});

let p4 = Promise.race([p1, p2, p3]);

p4.then(function(value) {
    console.log(value);     // 42.
});


--


let p1 = new Promise(function(resolve, reject) {
    resolve(42);
});

let p2 = Promise.reject(43);
let p3 = new Promise(function(resolve, reject) {
    resolve(44);
});

let p4 = Promise.race([p1, p2, p3]);

p4.catch(function(value) {
    console.log(value);     // 43.
});


--


class MyPromise extends Promise {

    // Użycie domyślnego konstruktora.

    success(resolve, reject) {
        return this.then(resolve, reject);
    }

    failure(reject) {
        return this.catch(reject);
    }

}

let promise = new MyPromise(function(resolve, reject) {
    resolve(42);
});

promise.success(function(value) {
    console.log(value);             // 42.
}).failure(function(value) {
    console.log(value);
});


--


let p1 = new Promise(function(resolve, reject) {
    resolve(42);
});

let p2 = MyPromise.resolve(p1);
p2.success(function(value) {
    console.log(value);                 // 42.
});

console.log(p2 instanceof MyPromise);   // Wartość true.


--


let fs = require("fs");

function run(taskDef) {

    // Utworzenie iteratora i udostępnienie go w kodzie.
    let task = taskDef();

    // Uruchomienie zadania.
    let result = task.next();

    // Funkcja rekurencyjna nieustannie wywołująca metodę next().
    function step() {

        // Jeżeli zostało cokolwiek do zrobienia.
        if (!result.done) {
            if (typeof result.value === "function") {
                result.value(function(err, data) {
                    if (err) {
                        result = task.throw(err);
                        return;
                    }

                    result = task.next(data);
                    step();
                });
            } else {
                result = task.next(result.value);
                step();
            }

        }

    }

    // Uruchomienie procesu.
    step();

}

// Zdefiniowanie funkcji przeznaczonej do użycia wraz z komponentem uruchamiającym zadanie.

function readFile(filename) {
    return function(callback) {
        fs.readFile(filename, callback);
    };
}

// Uruchomienie zadania.

run(function*() {
    let contents = yield readFile("config.json");
    doSomethingWith(contents);
    console.log("Gotowe!");
});


--


let fs = require("fs");

function run(taskDef) {
  // Utworzenie iteratora.
    let task = taskDef();

    // Uruchomienie zadania.
    let result = task.next();

    // Funkcja rekurencyjna przeprowadzająca iterację.
    (function step() {

        // Jeżeli zostało cokolwiek do zrobienia.
        if (!result.done) {

            // Rozstrzygnięcie obietnicy, aby ułatwić sobie zadanie.
            let promise = Promise.resolve(result.value);
            promise.then(function(value) {
                result = task.next(value);
                step();
            }).catch(function(error) {
                result = task.throw(error);
                step();
            });

        }
    }());
}

// Zdefiniowanie funkcji przeznaczonej do użycia wraz z komponentem uruchamiającym zadanie.

function readFile(filename) {
    return new Promise(function(resolve, reject) {
        fs.readFile(filename, function(err, contents) {
            if (err) {
                reject(err);
            } else {
                resolve(contents);
            }
        });
    });
}

// Uruchomienie zadania.

run(function*() {
    let contents = yield readFile("config.json");
    doSomethingWith(contents);
    console.log("Gotowe!");
});


--


(async function() {
    let contents = await readFile("config.json");
    doSomethingWith(contents);
    console.log("Gotowe!");
});
