var set = Object.create(null);

set.foo = true;

// Sprawdzenie istnienia.
if (set.foo) {
    // Kod przeznaczony do wykonania.
}


--


var map = Object.create(null);
map.foo = "bar";

// Pobranie wartości.
var value = map.foo;

console.log(value);         // "bar".


--


var map = Object.create(null);
map[5] = "foo";

console.log(map["5"]);      // "foo".


--


var map = Object.create(null),
    key1 = {},
    key2 = {};
map[key1] = "foo";

console.log(map[key2]);     // "foo".


--


var map = Object.create(null);

map.count = 1;

// Sprawdzenie istnienia "count" lub wartości innej niż zero?
if (map.count) {
    // Kod przeznaczony do wykonania.
}


--


let set = new Set();
set.add(5);
set.add("5");

console.log(set.size);    // 2.


--


let set = new Set(),
    key1 = {},
    key2 = {};

set.add(key1);
set.add(key2);

console.log(set.size);    // 2.


--


let set = new Set();
set.add(5);
set.add("5");
set.add(5);     // To jest powtórzone wywołanie — będzie zignorowane.

console.log(set.size);    // 2.


--


let set = new Set([1, 2, 3, 4, 5, 5, 5, 5]);
console.log(set.size);    // 5.


--


let set = new Set();
set.add(5);
set.add("5");

console.log(set.has(5));    // Wartość true.
console.log(set.has(6));    // Wartość false.


--


let set = new Set();
set.add(5);
set.add("5");
console.log(set.has(5));    // Wartość true.

set.delete(5);

console.log(set.has(5));    // Wartość false.
console.log(set.size);      // 1.

set.clear();

console.log(set.has("5"));  // Wartość false.
console.log(set.size);      // 0.


--


let set = new Set([1, 2]);

set.forEach(function(value, key, ownerSet) {
    console.log(key + " " + value);
    console.log(ownerSet === set);
});


--


let set = new Set([1, 2]);

let processor = {
    output(value) {
        console.log(value);
    },
    process(dataSet) {
        dataSet.forEach(function(value) {
            this.output(value);
        }, this);
    }
};

processor.process(set);


--


let set = new Set([1, 2]);

let processor = {
    output(value) {
        console.log(value);
    },
    process(dataSet) {
        dataSet.forEach(value => this.output(value));
    }
};

processor.process(set);


--


let set = new Set([1, 2, 3, 3, 3, 4, 5]),
    array = [...set];

console.log(array);             // [1,2,3,4,5].


--


function eliminateDuplicates(items) {
    return [...new Set(items)];
}

let numbers = [1, 2, 3, 3, 3, 4, 5],
    noDuplicates = eliminateDuplicates(numbers);

console.log(noDuplicates);      // [1,2,3,4,5].


--


let set = new Set(),
    key = {};

set.add(key);
console.log(set.size);      // 1.

// Usunięcie pierwotnego odwołania.
key = null;

console.log(set.size);      // 1.

// Przywrócenie z powrotem pierwotnego odwołania.
key = [...set][0];


--


let set = new WeakSet(),
    key = {};

// Dodanie obiektu do zbioru.
set.add(key);

console.log(set.has(key));      // Wartość true.

set.delete(key);

console.log(set.has(key));      // Wartość false.


--


let key1 = {},
    key2 = {},
    set = new WeakSet([key1, key2]);

console.log(set.has(key1));     // Wartość true.
console.log(set.has(key2));     // Wartość true.


--


let set = new WeakSet(),
    key = {};

// Dodanie obiektu do zbioru.
set.add(key);

console.log(set.has(key));      // Wartość true.

// Usunięcie ostatniego silnego odwołania do key (to jednocześnie usuwa ten element ze słabego zbioru).
key = null;


--


let map = new Map();
map.set("title", "Poznajemy ECMAScript 6");
map.set("year", 2016);

console.log(map.get("title"));      // "Poznajemy ECMAScript 6".
console.log(map.get("year"));       // 2016.


--


let map = new Map(),
    key1 = {},
    key2 = {};

map.set(key1, 5);
map.set(key2, 42);

console.log(map.get(key1));         // 5.
console.log(map.get(key2));         // 42.


--


let map = new Map();
map.set("name", "Nicholas");
map.set("age", 25);

console.log(map.size);          // 2.

console.log(map.has("name"));   // Wartość true.
console.log(map.get("name"));   // "Nicholas".

console.log(map.has("age"));    // Wartość true.
console.log(map.get("age"));    // 25.

map.delete("name");
console.log(map.has("name"));   // Wartość false.
console.log(map.get("name"));   // undefined.
console.log(map.size);          // 1.

map.clear();
console.log(map.has("name"));   // Wartość false.
console.log(map.get("name"));   // undefined.
console.log(map.has("age"));    // Wartość false.
console.log(map.get("age"));    // undefined.
console.log(map.size);          // 0.


--


let map = new Map([["name", "Nicholas"], ["age", 25]]);

console.log(map.has("name"));   // Wartość true.
console.log(map.get("name"));   // "Nicholas".
console.log(map.has("age"));    // Wartość true.
console.log(map.get("age"));    // 25.
console.log(map.size);          // 2.


--


let map = new Map([["name", "Nicholas"], ["age", 25]]);

map.forEach(function(value, key, ownerMap) {
    console.log(key + " " + value);
    console.log(ownerMap === map);
});


--


let map = new WeakMap(),
    element = document.querySelector(".element");

map.set(element, "Original");

let value = map.get(element);
console.log(value);             // "Original".

// Usunięcie elementu.
element.parentNode.removeChild(element);
element = null;

// Na tym etapie słaba mapa jest pusta.


--


let key1 = {},
    key2 = {},
    map = new WeakMap([[key1, "Witaj"], [key2, 42]]);

console.log(map.has(key1));     // Wartość true.
console.log(map.get(key1));     // "Witaj".
console.log(map.has(key2));     // Wartość true.
console.log(map.get(key2));     // 42.


--


let map = new WeakMap(),
    element = document.querySelector(".element");

map.set(element, "Original");
console.log(map.has(element));   // Wartość true.
console.log(map.get(element));   // "Original".

map.delete(element);
console.log(map.has(element));   // Wartość false.
console.log(map.get(element));   // undefined.


--


function Person(name) {
    this._name = name;
}

Person.prototype.getName = function() {
    return this._name;
};


--


var Person = (function() {

    var privateData = {},
        privateId = 0;

    function Person(name) {
        Object.defineProperty(this, "_id", { value: privateId++ });

        privateData[this._id] = {
            name: name
        };
    }

    Person.prototype.getName = function() {
        return privateData[this._id].name;
    };

    return Person;
}());


--


let Person = (function() {

    let privateData = new WeakMap();

    function Person(name) {
        privateData.set(this, { name: name });
    }

    Person.prototype.getName = function() {
        return privateData.get(this).name;
    };

    return Person;
}());
