let firstName = Symbol();
let person = {};

person[firstName] = "Nicholas";
console.log(person[firstName]);     // "Nicholas".


--


let firstName = Symbol("first name");
let person = {};

person[firstName] = "Nicholas";

console.log("first name" in person);        // Wartość false.
console.log(person[firstName]);             // "Nicholas".
console.log(firstName);                     // "Symbol(first name)".


--


let symbol = Symbol("symbol testowy");
console.log(typeof symbol);         // "symbol".


--


let firstName = Symbol("first name");

// Użycie generowanych właściwości w literale obiektu.
let person = {
    [firstName]: "Nicholas"
};

// Utworzenie właściwości tylko do odczytu.
Object.defineProperty(person, firstName, { writable: false });

let lastName = Symbol("last name");

Object.defineProperties(person, {
    [lastName]: {
        value: "Zakas",
        writable: false
    }
});

console.log(person[firstName]);     // "Nicholas".
console.log(person[lastName]);      // "Zakas".


--


let uid = Symbol.for("uid");
let object = {};

object[uid] = "12345";

console.log(object[uid]);       // "12345".
console.log(uid);               // "Symbol(uid)".


--


let uid = Symbol.for("uid");
let object = {
    [uid]: "12345"
};

console.log(object[uid]);       // "12345".
console.log(uid);               // "Symbol(uid)".

let uid2 = Symbol.for("uid");

console.log(uid === uid2);      // Wartość true.
console.log(object[uid2]);      // "12345".
console.log(uid2);              // "Symbol(uid)".


--


let uid = Symbol.for("uid");
console.log(Symbol.keyFor(uid));    // "uid".

let uid2 = Symbol.for("uid");
console.log(Symbol.keyFor(uid2));   // "uid".

let uid3 = Symbol("uid");
console.log(Symbol.keyFor(uid3));   // undefined.


--


let uid = Symbol.for("uid"),
    desc = String(uid);

console.log(desc);              // "Symbol(uid)".


--


var uid = Symbol.for("uid"),
    desc = uid + "";            // Błąd!


--


var uid = Symbol.for("uid"),
    sum = uid / 1;            // Błąd!


--


let uid = Symbol.for("uid");
let object = {
    [uid]: "12345"
};

let symbols = Object.getOwnPropertySymbols(object);

console.log(symbols.length);        // 1.
console.log(symbols[0]);            // "Symbol(uid)".
console.log(object[symbols[0]]);    // "12345".


--


function MyObject() {
    // Pusta implementacja.
}

Object.defineProperty(MyObject, Symbol.hasInstance, {
    value: function(v) {
        return false;
    }
});

let obj = new MyObject();

console.log(obj instanceof MyObject);       // Wartość false.


--


function SpecialNumber() {
    // Pusta implementacja.
}

Object.defineProperty(SpecialNumber, Symbol.hasInstance, {
    value: function(v) {
        return (v instanceof Number) && (v >=1 && v <= 100);
    }
});

var two = new Number(2),
    zero = new Number(0);

console.log(two instanceof SpecialNumber);    // Wartość true.
console.log(zero instanceof SpecialNumber);   // Wartość false.


--


let colors1 = [ "czerwony", "zielony" ],
    colors2 = colors1.concat([ "niebieski", "czarny" ]);

console.log(colors2.length);    // 4.
console.log(colors2);           // ["czerwony","zielony","niebieski","czarny"].


--


let colors1 = [ "czerwony", "zielony" ],
    colors2 = colors1.concat([ "niebieski", "czarny" ], "brązowy");

console.log(colors2.length);    // 5.
console.log(colors2);           // ["czerwony","zielony","niebieski","czarny","brązowy"].


--


let collection = {
    0: "Witaj",
    1: "świecie",
    length: 2,
    [Symbol.isConcatSpreadable]: true
};

let messages = [ "Cześć" ].concat(collection);

console.log(messages.length);    // 3.
console.log(messages);           // ["Cześć","Witaj","świecie"].


--


// To w praktyce odpowiednik wyrażenia regularnego /^.{10}$/.
let hasLengthOf10 = {
    [Symbol.match]: function(value) {
        return value.length === 10 ? [value.substring(0, 10)] : null;
    },
    [Symbol.replace]: function(value, replacement) {
        return value.length === 10 ? replacement + value.substring(10) : value;
    },
    [Symbol.search]: function(value) {
        return value.length === 10 ? 0 : -1;
    },
    [Symbol.split]: function(value) {
        return value.length === 10 ? ["", ""] : [value];
    }
};

let message1 = "Witaj, świecie",   // 14 znaków.
    message2 = "Witaj, Jan";       // 10 znaków.

let match1 = message1.match(hasLengthOf10),
    match2 = message2.match(hasLengthOf10);

console.log(match1);            // null.
console.log(match2);            // ["Witaj, Jan"].

let replace1 = message1.replace(hasLengthOf10),
    replace2 = message2.replace(hasLengthOf10);

console.log(replace1);          // "Witaj, świecie".
console.log(replace2);          // "Witaj, Jan".

let search1 = message1.search(hasLengthOf10),
    search2 = message2.search(hasLengthOf10);

console.log(search1);           // –1.
console.log(search2);           // 0.

let split1 = message1.split(hasLengthOf10),
    split2 = message2.split(hasLengthOf10);

console.log(split1);            // ["Witaj, świecie"].
console.log(split2);            // ["", ""].


--


function Temperature(degrees) {
    this.degrees = degrees;
}
Temperature.prototype[Symbol.toPrimitive] = function(hint) {

    switch (hint) {
        case "string":
            return this.degrees + "\u00b0"; // Znak oznaczający stopnie.

        case "number":
            return this.degrees;

        case "default":
            return this.degrees + " stopni";
    }
};

var freezing = new Temperature(32);

console.log(freezing + "!");            // "32 stopni!".
console.log(freezing / 2);              // 16.
console.log(String(freezing));          // "32°".


--


function isArray(value) {
    return Object.prototype.toString.call(value) === "[object Array]";
}

console.log(isArray([]));   // Wartość true.


--


function supportsNativeJSON() {
    return typeof JSON !== "undefined" &&
        Object.prototype.toString.call(JSON) === "[object JSON]";
}


--


function Person(name) {
    this.name = name;
}

Person.prototype[Symbol.toStringTag] = "Person";

var me = new Person("Nicholas");

console.log(me.toString());                         // "[object Person]".
console.log(Object.prototype.toString.call(me));    // "[object Person]".


--


function Person(name) {
    this.name = name;
}

Person.prototype[Symbol.toStringTag] = "Person";

Person.prototype.toString = function() {
    return this.name;
};

var me = new Person("Nicholas");

console.log(me.toString());                         // "Nicholas".
console.log(Object.prototype.toString.call(me));    // "[object Person]".


--


function Person(name) {
    this.name = name;
}

Person.prototype[Symbol.toStringTag] = "Array";

Person.prototype.toString = function() {
    return this.name;
};

var me = new Person("Nicholas");

console.log(me.toString());                         // "Nicholas".
console.log(Object.prototype.toString.call(me));    // "[object Array]".


--


Array.prototype[Symbol.toStringTag] = "Magic";

var values = [];

console.log(Object.prototype.toString.call(values));    // "[object Magic]".


--


var values = [1, 2, 3],
    colors = ["czerwony", "zielony", "niebieski"],
    color = "czarny";

with(colors) {
    push(color);
    push(...values);
}

console.log(colors);    // ["czerwony", "zielony", "niebieski", "czarny", 1, 2, 3].


--


// Definicja właściwości domyślnie wbudowana w ECMAScript 6.
Array.prototype[Symbol.unscopables] = Object.assign(Object.create(null), {
    copyWithin: true,
    entries: true,
    fill: true,
    find: true,
    findIndex: true,
    keys: true,
    values: true
});
