let options = {
    repeat: true,
    save: false
};

// Wyodrębnienie danych z obiektu.
let repeat = options.repeat,
    save = options.save;


--


let node = {
    type: "Identifier",
    name: "foo"
};

let { type, name } = node;

console.log(type);      // "Identifier".
console.log(name);      // "foo".


--


// Błąd składni!
var { type, name };

// Błąd składni!
let { type, name };

// Błąd składni!
const { type, name };


--


let node = {
    type: "Identifier",
    name: "foo"
},
type = "Literal",
name = 5;

// Przypisanie innej wartości za pomocą destrukturyzacji.
({ type, name } = node);

console.log(type);      // "Identifier".
console.log(name);      // "foo".


--


let node = {
    type: "Identifier",
    name: "foo"
},
type = "Literal",
name = 5;

function outputInfo(value) {
    console.log(value === node);        // Wartość true.
}

outputInfo({ type, name } = node);

console.log(type);      // "Identifier".
console.log(name);      // "foo".


--


let node = {
    type: "Identifier",
    name: "foo"
};

let { type, name, value } = node;

console.log(type);      // "Identifier".
console.log(name);      // "foo".
console.log(value);     // undefined.


--


let node = {
    type: "Identifier",
    name: "foo"
};

let { type, name, value = true } = node;

console.log(type);      // "Identifier".
console.log(name);      // "foo".
console.log(value);     // Wartość true.


--


let node = {
    type: "Identifier",
    name: "foo"
};

let { type: localType, name: localName } = node;

console.log(localType);     // "Identifier".
console.log(localName);     // "foo".


--


let node = {
    type: "Identifier"
};

let { type: localType, name: localName = "bar" } = node;

console.log(localType);     // "Identifier".
console.log(localName);     // "bar".


--


let node = {
    type: "Identifier",
    name: "foo",
    loc: {
        start: {
            line: 1,
            column: 1
        },
        end: {
            line: 1,
            column: 4
        }
    }
};

let { loc: { start }} = node;

console.log(start.line);        // 1.
console.log(start.column);      // 1.


--


let node = {
    type: "Identifier",
    name: "foo",
    loc: {
        start: {
            line: 1,
            column: 1
        },
        end: {
            line: 1,
            column: 4
        }
    }
};

// Wyodrębnienie node.loc.start.
let { loc: { start: localStart }} = node;

console.log(localStart.line);   // 1.
console.log(localStart.column); // 1.


--


// Brak zadeklarowanych zmiennych!
let { loc: {} } = node;


--


let colors = [ "czerwony", "zielony", "niebieski" ];

let [ firstColor, secondColor ] = colors;

console.log(firstColor);        // "czerwony".
console.log(secondColor);       // "zielony".


--


let colors = [ "czerwony", "zielony", "niebieski" ];

let [ , , thirdColor ] = colors;

console.log(thirdColor);        // "niebieski".


--


let colors = [ "czerwony", "zielony", "niebieski" ],
    firstColor = "czarny",
    secondColor = "fioletowy";

[ firstColor, secondColor ] = colors;

console.log(firstColor);        // "czerwony".
console.log(secondColor);       // "zielony".


--


// Zamiana wartości zmiennych w ECMAScript 5.
let a = 1,
    b = 2,
    tmp;

tmp = a;
a = b;
b = tmp;

console.log(a);     // 2.
console.log(b);     // 1.


--


// Zamiana wartości zmiennych w ECMAScript 6.
let a = 1,
    b = 2;

[ a, b ] = [ b, a ];

console.log(a);     // 2.
console.log(b);     // 1.


--


let colors = [ "czerwony" ];

let [ firstColor, secondColor = "zielony" ] = colors;

console.log(firstColor);        // "czerwony".
console.log(secondColor);       // "zielony".


--


let colors = [ "czerwony", [ "zielony", "jasnozielony" ], "niebieski" ];

// Później.

let [ firstColor, [ secondColor ] ] = colors;

console.log(firstColor);        // "czerwony".
console.log(secondColor);       // "zielony".


--


let colors = [ "czerwony", "zielony", "niebieski" ];

let [ firstColor, ...restColors ] = colors;

console.log(firstColor);        // "czerwony".
console.log(restColors.length); // 2.
console.log(restColors[0]);     // "zielony".
console.log(restColors[1]);     // "niebieski".


--


// Powielenie tablicy w ECMAScript 5.
var colors = [ "czerwony", "zielony", "niebieski" ];
var clonedColors = colors.concat();

console.log(clonedColors);      // "[czerwony,zielony,niebieski]".


--


// Powielenie tablicy w ECMAScript 6.
let colors = [ "czerwony", "zielony", "niebieski" ];
let [ ...clonedColors ] = colors;

console.log(clonedColors);      // "[czerwony,zielony,niebieski]".


--


let node = {
    type: "Identifier",
    name: "foo",
    loc: {
        start: {
            line: 1,
            column: 1
        },
        end: {
            line: 1,
            column: 4
        }
    },
    range: [0, 3]
};

let {
    loc: { start },
    range: [ startIndex ]
} = node;

console.log(start.line);        // 1.
console.log(start.column);      // 1.
console.log(startIndex);        // 0.


--


// Parametry obiektu options przedstawiają parametry dodatkowe.
function setCookie(name, value, options) {

    options = options || {};

    let secure = options.secure,
        path = options.path,
        domain = options.domain,
        expires = options.expires;
    // Kod odpowiedzialny za zdefiniowanie cookie.
}

// Trzeci argument jest mapowany na obiekt options.
setCookie("type", "js", {
    secure: true,
    expires: 60000
});


--


function setCookie(name, value, { secure, path, domain, expires }) {

    // Kod odpowiedzialny za zdefiniowanie cookie.
}

setCookie("type", "js", {
    secure: true,
    expires: 60000
});


--


// Błąd!
setCookie("type", "js");


--


function setCookie(name, value, options) {

    let { secure, path, domain, expires } = options;

    // Kod odpowiedzialny za zdefiniowanie cookie.
}


--


function setCookie(name, value, { secure, path, domain, expires } = {}) {

    // Pusta implementacja.
}


--


function setCookie(name, value,
    {
        secure = false,
        path = "/",
        domain = "example.com",
        expires = new Date(Date.now() + 360000000)
    } = {}
) {

    // Pusta implementacja.
}
