function createPerson(name, age) {
    return {
        name: name,
        age: age
    };
}


--


function createPerson(name, age) {
    return {
        name,
        age
    };
}


--


var person = {
    name: "Nicholas",
    sayName: function() {
        console.log(this.name);
    }
};


--


var person = {
    name: "Nicholas",
    sayName() {
        console.log(this.name);
    }
};


--


var person = {},
    lastName = "last name";

person["first name"] = "Nicholas";
person[lastName] = "Zakas";

console.log(person["first name"]);      // "Nicholas".
console.log(person[lastName]);          // "Zakas".


--


var person = {
    "first name": "Nicholas"
};

console.log(person["first name"]);      // "Nicholas".


--


let lastName = "last name";

let person = {
    "first name": "Nicholas",
    [lastName]: "Zakas"
};

console.log(person["first name"]);      // "Nicholas".
console.log(person[lastName]);          // "Zakas".


--


var suffix = " name";

var person = {
    ["first" + suffix]: "Nicholas",
    ["last" + suffix]: "Zakas"
};

console.log(person["first name"]);      // "Nicholas".
console.log(person["last name"]);       // "Zakas".


--


console.log(+0 == -0);              // Wartość true.
console.log(+0 === -0);             // Wartość true.
console.log(Object.is(+0, -0));     // Wartość false.

console.log(NaN == NaN);            // Wartość false.
console.log(NaN === NaN);           // Wartość false.
console.log(Object.is(NaN, NaN));   // Wartość true.

console.log(5 == 5);                // Wartość true.
console.log(5 == "5");              // Wartość true.
console.log(5 === 5);               // Wartość true.
console.log(5 === "5");             // Wartość false.
console.log(Object.is(5, 5));       // Wartość true.
console.log(Object.is(5, "5"));     // Wartość false.


--


function mixin(receiver, supplier) {
    Object.keys(supplier).forEach(function(key) {
        receiver[key] = supplier[key];
    });

    return receiver;
}


--


function EventTarget() { /*...*/ }
EventTarget.prototype = {
    constructor: EventTarget,
    emit: function() { /*...*/ },
    on: function() { /*...*/ }
};

var myObject = {};
mixin(myObject, EventTarget.prototype);

myObject.emit("somethingChanged");


--


function EventTarget() { /*...*/ }
EventTarget.prototype = {
    constructor: EventTarget,
    emit: function() { /*...*/ },
    on: function() { /*...*/ }
}

var myObject = {}
Object.assign(myObject, EventTarget.prototype);

myObject.emit("somethingChanged");


--


var receiver = {};

Object.assign(receiver,
    {
        type: "js",
        name: "file.js"
    },
    {
        type: "css"
    }
);

console.log(receiver.type);     // "css".
console.log(receiver.name);     // "file.js".


--


var receiver = {},
    supplier = {
        get name() {
            return "file.js"
        }
    };

Object.assign(receiver, supplier);

var descriptor = Object.getOwnPropertyDescriptor(receiver, "name");

console.log(descriptor.value);      // "file.js".
console.log(descriptor.get);        // undefined.


--


"use strict";

var person = {
    name: "Nicholas",
    name: "Greg"        // Błąd składni w trybie ścisłym ES5.
};


--


"use strict";

var person = {
    name: "Nicholas",
    name: "Greg"        // Bez błędu w trybie ścisłym ES6.
};

console.log(person.name);       // "Greg".


--


var obj = {
    a: 1,
    0: 1,
    c: 1,
    2: 1,
    b: 1,
    1: 1
};

obj.d = 1;

console.log(Object.getOwnPropertyNames(obj).join(""));     // "012acbd".


--


let person = {
    getGreeting() {
        return "Witaj";
    }
};

let dog = {
    getGreeting() {
        return "Hau";
    }
};

// Prototypem jest person.
let friend = Object.create(person);
console.log(friend.getGreeting());                      // "Witaj".
console.log(Object.getPrototypeOf(friend) === person);  // Wartość true.

// Zmiana prototypu na dog.
Object.setPrototypeOf(friend, dog);
console.log(friend.getGreeting());                      // "Hau".
console.log(Object.getPrototypeOf(friend) === dog);     // Wartość true.


--


let person = {
    getGreeting() {
        return "Witaj";
    }
};

let dog = {
    getGreeting() {
        return "Hau";
    }
};

let friend = {
    getGreeting() {
        return Object.getPrototypeOf(this).getGreeting.call(this) + ", cześć!";
    }
};

// Prototypem jest person.
Object.setPrototypeOf(friend, person);
console.log(friend.getGreeting());                      // "Witaj, cześć!".
console.log(Object.getPrototypeOf(friend) === person);  // Wartość true.

// Prototypem jest dog.
Object.setPrototypeOf(friend, dog);
console.log(friend.getGreeting());                      // "Hau, cześć!".
console.log(Object.getPrototypeOf(friend) === dog);     // Wartość true.


--


let friend = {
    getGreeting() {
        // W poprzednim przykładzie to odpowiada poniższemu poleceniu.
        // Object.getPrototypeOf(this).getGreeting.call(this)
        return super.getGreeting() + ", cześć!";
    }
};


--


let friend = {
    getGreeting: function() {
        // Nastąpi zgłoszenie błędu składni.
        return super.getGreeting() + ", cześć!";

    }
};


--


let person = {
    getGreeting() {
        return "Witaj";
    }
};

// Prototypem jest person.
let friend = {
    getGreeting() {
        return Object.getPrototypeOf(this).getGreeting.call(this) + ", cześć!";
    }
};
Object.setPrototypeOf(friend, person);

// Prototypem jest friend.
let relative = Object.create(friend);

console.log(person.getGreeting());                  // "Witaj".
console.log(friend.getGreeting());                  // "Witaj, cześć!".
console.log(relative.getGreeting());                // Błąd!


--


let person = {
    getGreeting() {
        return "Witaj";
    }
};

// Prototypem jest person.
let friend = {
    getGreeting() {
        return super.getGreeting() + ", cześć!";
    }
};
Object.setPrototypeOf(friend, person);

// Prototypem jest friend.
let relative = Object.create(friend);

console.log(person.getGreeting());                  // "Witaj".
console.log(friend.getGreeting());                  // "Witaj, cześć!".
console.log(relative.getGreeting());                // "Witaj, cześć!".


--


let person = {

    // Metoda.
    getGreeting() {
        return "Witaj";
    }
};

// To nie jest metoda.
function shareGreeting() {
    return "Cześć!";
}


--


let person = {
    getGreeting() {
        return "Witaj";
    }
};

// Prototypem jest person.
let friend = {
    getGreeting() {
        return super.getGreeting() + ", cześć!";
    }
};
Object.setPrototypeOf(friend, person);

console.log(friend.getGreeting());  // "Witaj, cześć!".
