function makeRequest(url, timeout, callback) {

    timeout = timeout || 2000;
    callback = callback || function() {};

    // Pozostała część funkcji.
}


--


function makeRequest(url, timeout, callback) {

    timeout = (typeof timeout !== "undefined") ? timeout : 2000;
    callback = (typeof callback !== "undefined") ? callback : function() {};

    // Pozostała część funkcji.

}


--


function makeRequest(url, timeout = 2000, callback = function() {}) {

    // Pozostała część funkcji.

}


--


// Użycie wartości domyślnych dla timeout i callback.
makeRequest("/foo");

// Użycie wartości domyślnej dla callback.
makeRequest("/foo", 500);

// Wartości domyślne nie są używane.
makeRequest("/foo", 500, function(body) {
    doSomething(body);
});


--


function makeRequest(url, timeout = 2000, callback) {

    // Pozostała część funkcji.

}


--


// Użycie wartości domyślnej dla timeout.
makeRequest("/foo", undefined, function(body) {
    doSomething(body);
});

// Użycie wartości domyślnej dla timeout.
makeRequest("/foo");

// Wartość domyślna dla timeout nie jest używana.
makeRequest("/foo", null, function(body) {
    doSomething(body);
});


--


function mixArgs(first, second) {
    console.log(first === arguments[0]);
    console.log(second === arguments[1]);
    first = "c";
    second = "d";
    console.log(first === arguments[0]);
    console.log(second === arguments[1]);
}

mixArgs("a", "b");


--


function mixArgs(first, second) {
    "use strict";

    console.log(first === arguments[0]);
    console.log(second === arguments[1]);
    first = "c";
    second = "d"
    console.log(first === arguments[0]);
    console.log(second === arguments[1]);
}

mixArgs("a", "b");


--


// Ta funkcja nie działa w trybie ścisłym.
function mixArgs(first, second = "b") {
    console.log(arguments.length);
    console.log(first === arguments[0]);
    console.log(second === arguments[1]);
    first = "c";
    second = "d"
    console.log(first === arguments[0]);
    console.log(second === arguments[1]);
}

mixArgs("a");


--


function getValue() {
    return 5;
}

function add(first, second = getValue()) {
    return first + second;
}

console.log(add(1, 1));     // 2.
console.log(add(1));        // 6.


--


let value = 5;

function getValue() {
    return value++;
}

function add(first, second = getValue()) {
    return first + second;
}

console.log(add(1, 1));     // 2.
console.log(add(1));        // 6.
console.log(add(1));        // 7.


--


function add(first, second = first) {
    return first + second;
}

console.log(add(1, 1));              // 2.
console.log(add(1));                 // 2.


--


function getValue(value) {
    return value + 5;
}

function add(first, second = getValue(first)) {
    return first + second;
}

console.log(add(1, 1));              // 2.
console.log(add(1));                 // 7.


--


function add(first = second, second) {
    return first + second;
}

console.log(add(1, 1));              // 2.
console.log(add(undefined, 1));      // Następuje zgłoszenie błędu.


--


function getValue(value) {
    return value + 5;
}

function add(first, second = getValue(first)) {
    return first + second;
}

console.log(add(1, 1));     // 2.
console.log(add(1));        // 7.


--


// Używana przez JavaScript postać wywołania add(1, 1).
let first = 1;
let second = 1;

// Używana przez JavaScript postać wywołania add(1).
let first = 1;
let second = getValue(first);


--


function add(first = second, second) {
    return first + second;
}

console.log(add(1, 1));         // 2.
console.log(add(undefined, 1)); // Następuje zgłoszenie błędu.


--


// Używana przez JavaScript postać wywołania add(1, 1).
let first = 1;
let second = 1;

// Używana przez JavaScript postać wywołania add(undefined, 1).
let first = second;
let second = 1;


--


function pick(object) {
    let result = Object.create(null);

    // Rozpoczynamy od drugiego parametru.
    for (let i = 1, len = arguments.length; i < len; i++) {
        result[arguments[i]] = object[arguments[i]];
    }

    return result;
}

let book = {
    title: "Poznajemy ECMAScript 6",
    author: "Nicholas C. Zakas",
    year: 2016
};

let bookData = pick(book, "author", "year");

console.log(bookData.author);   // "Nicholas C. Zakas".
console.log(bookData.year);     // 2016.


--


function pick(object, ...keys) {
    let result = Object.create(null);

    for (let i = 0, len = keys.length; i < len; i++) {
        result[keys[i]] = object[keys[i]];
    }

    return result;
}


--


// Błąd składni: nie można umieścić parametru nazwanego po parametrze resztowym.
function pick(object, ...keys, last) {
    let result = Object.create(null);

    for (let i = 0, len = keys.length; i < len; i++) {
        result[keys[i]] = object[keys[i]];
    }

    return result;
}


--


let object = {

    // Błąd składni: parametru resztowego nie można używać w metodzie typu setter.
    set name(...value) {
        // Dowolne operacje.
    }
};


--


function checkArgs(...args) {
    console.log(args.length);
    console.log(arguments.length);
    console.log(args[0], arguments[0]);
    console.log(args[1], arguments[1]);
}

checkArgs("a", "b");


--


var add = new Function("first", "second", "return first + second");

console.log(add(1, 1));     // 2.


--


var add = new Function("first", "second = first",
    "return first + second");

console.log(add(1, 1));     // 2.
console.log(add(1));        // 2.


--


var pickFirst = new Function("...args", "return args[0]");

console.log(pickFirst(1, 2));   // 1.


--


let value1 = 25,
    value2 = 50;

console.log(Math.max(value1, value2));      // 50.


--


let values = [25, 50, 75, 100]

console.log(Math.max.apply(Math, values));  // 100.


--


let values = [25, 50, 75, 100]

// Odpowiednik poniższego wywołania.
// console.log(Math.max(25, 50, 75, 100));
console.log(Math.max(...values));           // 100.


--


let values = [-25, -50, -75, -100]

console.log(Math.max(...values, 0));        // 0.


--


function doSomething() {
    // Pusta implementacja.
}

var doAnotherThing = function() {
    // Pusta implementacja.
};

console.log(doSomething.name);          // "doSomething".
console.log(doAnotherThing.name);       // "doAnotherThing".


--


var doSomething = function doSomethingElse() {
    // Pusta implementacja.
};

var person = {
    get firstName() {
        return "Nicholas"
    },
    sayName: function() {
        console.log(this.name);
    }
}

console.log(doSomething.name);      // "doSomethingElse".
console.log(person.sayName.name);   // "sayName".
console.log(person.firstName.name); // "get firstName".


--


var doSomething = function() {
    // Pusta implementacja.
};

console.log(doSomething.bind().name);   // "bound doSomething".

console.log((new Function()).name);     // "anonymous".


--


function Person(name) {
    this.name = name;
}

var person = new Person("Nicholas");
var notAPerson = Person("Nicholas");

console.log(person);        // "[Object object]".
console.log(notAPerson);    // "undefined".


--


function Person(name) {
    if (this instanceof Person) {
        this.name = name;   // Użycie operatora new.
    } else {
        throw new Error("Funkcję Person() trzeba wywołać wraz z operatorem new.")
    }
}

var person = new Person("Nicholas");
var notAPerson = Person("Nicholas");  // Następuje zgłoszenie błędu.


--


function Person(name) {
    if (this instanceof Person) {
        this.name = name;   
    } else {
        throw new Error("Funkcję Person() trzeba wywołać wraz z operatorem new.")
    }
}

var person = new Person("Nicholas");
var notAPerson = Person.call(person, "Michael");    // To polecenie działa!


--


function Person(name) {
    if (typeof new.target !== "undefined") {
        this.name = name;   
    } else {
        throw new Error("Funkcję Person() trzeba wywołać wraz z operatorem new.")
    }
}

var person = new Person("Nicholas");
var notAPerson = Person.call(person, "Michael");    // Błąd!


--


function Person(name) {
    if (typeof new.target === Person) {
        this.name = name;   
    } else {
        throw new Error("Funkcję Person() trzeba wywołać wraz z operatorem new.")
    }
}

function AnotherPerson(name) {
    Person.call(this, name);
}

var person = new Person("Nicholas");
var anotherPerson = new AnotherPerson("Nicholas");  // Błąd!


--


"use strict";

if (true) {

    // Następuje zgłoszenie błędu składni w specyfikacji ES5, ale nie w ES6.
    function doSomething() {
        // Pusta implementacja.
    }
}


--


"use strict";

if (true) {

    console.log(typeof doSomething);        // "function".

    function doSomething() {
        // Pusta implementacja.
    }

    doSomething();
}

console.log(typeof doSomething);            // "undefined".


--


"use strict";

if (true) {

    console.log(typeof doSomething);        // Następuje zgłoszenie błędu.

    let doSomething = function () {
        // Pusta implementacja.
    }
    doSomething();
}

console.log(typeof doSomething);


--


// Zachowanie w specyfikacji ECMAScript 6.
if (true) {

    console.log(typeof doSomething);        // "function".

    function doSomething() {
        // Pusta implementacja.
    }

    doSomething();
}

console.log(typeof doSomething);            // "function".


--


let reflect = value => value;

// To praktycznie jest odpowiednik poniższego fragmentu kodu.

let reflect = function(value) {
    return value;
};


--


let sum = (num1, num2) => num1 + num2;

// To praktycznie jest odpowiednik poniższego fragmentu kodu.

let sum = function(num1, num2) {
    return num1 + num2;
};


--


let getName = () => "Nicholas";

// To praktycznie jest odpowiednik poniższego fragmentu kodu.

let getName = function() {
    return "Nicholas";
};


--


let sum = (num1, num2) => {
    return num1 + num2;
};

// To praktycznie jest odpowiednik poniższego fragmentu kodu.

let sum = function(num1, num2) {
    return num1 + num2;
};


--


let doNothing = () => {};

// To praktycznie jest odpowiednik poniższego fragmentu kodu.

let doNothing = function() {};


--


let getTempItem = id => ({ id: id, name: "Temp" });

// To praktycznie jest odpowiednik poniższego fragmentu kodu.

let getTempItem = function(id) {

    return {
        id: id,
        name: "Temp"
    };
};


--


let person = function(name) {

    return {
        getName: function() {
            return name;
        }
    };

}("Nicholas");

console.log(person.getName());      // "Nicholas".


--


let person = ((name) => {

    return {
        getName: function() {
            return name;
        }
    };
})("Nicholas");

console.log(person.getName());      // "Nicholas".


--


let PageHandler = {

    id: "123456",

    init: function() {
        document.addEventListener("click", function(event) {
            this.doSomething(event.type);     // Błąd.
        }, false);
    },

    doSomething: function(type) {
        console.log("Obsługa " + type  + " dla " + this.id);
    }

};


--


let PageHandler = {

    id: "123456",

    init: function() {
    document.addEventListener("click", (function(event) {
            this.doSomething(event.type);     // Bez błędu.
        }).bind(this), false);
    },

    doSomething: function(type) {
        console.log("Obsługa " + type  + " dla " + this.id);
    }
};


--


let PageHandler = {

    id: "123456",

    init: function() {
        document.addEventListener("click",
                event => this.doSomething(event.type), false);
    },

    doSomething: function(type) {
        console.log("Obsługa " + type  + " dla " + this.id);
    }

};


--


var MyType = () => {},
    object = new MyType();  // Błąd — funkcji strzałki nie można użyć wraz z operatorem 'new'.


--


var result = values.sort(function(a, b) {
    return a - b;
});


--


function createArrowFunctionReturningFirstArg() {
    return () => arguments[0];
}

var arrowFunction = createArrowFunctionReturningFirstArg(5);

console.log(arrowFunction());       // 5.


--


var comparator = (a, b) => a - b;

console.log(typeof comparator);                 // "function".
console.log(comparator instanceof Function);    // Wartość true.


--


var sum = (num1, num2) => num1 + num2;

console.log(sum.call(null, 1, 2));      // 3.
console.log(sum.apply(null, [1, 2]));   // 3.

var boundSum = sum.bind(null, 1, 2);

console.log(boundSum());                // 3.


--


function doSomething() {
    return doSomethingElse();   // Wywołanie ogonowe.
}


--


"use strict";

function doSomething() {
    // Kod zoptymalizowany.
    return doSomethingElse();
}


--


"use strict";

function doSomething() {
    // Brak optymalizacji — brak wartości zwrotnej.
    doSomethingElse();
}


--


"use strict";

function doSomething() {
    // Brak optymalizacji — operacja dodawania jest wykonywana po zakończeniu wywołania ogonowego.
    return 1 + doSomethingElse();
}


--


"use strict";

function doSomething() {
    // Brak optymalizacji — wywołanie nie znajduje się na samym końcu.
    var result = doSomethingElse();
    return result;
}


--


"use strict";

function doSomething() {
    var num = 1,
        func = () => num;

    // Brak optymalizacji — funkcja jest domknięciem.
    return func();
}


--


function factorial(n) {

    if (n <= 1) {
        return 1;
    } else {

        // Brak optymalizacji — konieczność przeprowadzenia mnożenia po zwrocie wartości przez factorial().
        return n * factorial(n - 1);
    }
}


--


function factorial(n, p = 1) {

    if (n <= 1) {
        return 1 * p;
    } else {
        let result = n * p;

        // Kod zoptymalizowany.
        return factorial(n - 1, result);
    }
}
