/******************************************************************************* 
 * Copyright (c) 2005, 2007 Naci Dai, Lawrence Mandel, and Arthur Ryman. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * 
 * This sample developed for the book 
 *     Eclipse Web Tools Platform: Developing Java Web Applications
 * See http://eclipsewtp.org 
 *******************************************************************************/ 
package org.eclipsewtp.wsdlextensions;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.wst.wsdl.Binding;
import org.eclipse.wst.wsdl.ui.internal.asd.facade.IBinding;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BindingGenerationAction implements IObjectActionDelegate {
  private StructuredSelection selection = null;
  
  public BindingGenerationAction() {
    super();
  }

  public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    // Do nothing.
  }

  public void run(IAction action) {
    Object obj = ((StructuredSelection)selection).getFirstElement();
    if(obj instanceof IBinding) {
      Binding bindingModelObj = (Binding)((Adapter)obj).getTarget();
      Element domBindingElement = bindingModelObj.getElement();
      
      Document doc = domBindingElement.getOwnerDocument();
      Element docElem = doc.getDocumentElement();
      docElem.setAttribute("xmlns:wtpsoap", 
    		               "http://eclipsewtp.org/wsdl/soap/");
      Element soapBinding = 
    	  doc.createElementNS("http://eclipsewtp.org/wsdl/soap/", 
    			              "wtpsoap:binding");
      soapBinding.setAttribute("style", "document");
      soapBinding.setAttribute("transport", 
    		                   "http://schemas.xmlsoap.org/soap/http");
      Node firstBindingChild = domBindingElement.getFirstChild();
      if(firstBindingChild == null) {
    	domBindingElement.appendChild(soapBinding);
      }
      else {
        domBindingElement.insertBefore(soapBinding, firstBindingChild);
      }
      
      NodeList operations = 
    	  domBindingElement.getElementsByTagNameNS(
    			  "http://schemas.xmlsoap.org/wsdl/", "operation");
      int numOperations = operations.getLength();
      for(int i = 0; i < numOperations; i++) {
    	Element operation = (Element)operations.item(i);
    	String operationName = operation.getAttribute("name");
    	Element soapOperation = 
    		doc.createElementNS("http://eclipsewtp.org/wsdl/soap/", 
    				            "wtpsoap:operation");
        String soapAction = docElem.getAttribute("targetNamespace");
        if(!soapAction.endsWith("/"))
          soapAction += "/";
        soapAction += operationName;
        soapOperation.setAttribute("soapAction", soapAction);
          
        Node firstOperationChild = operation.getFirstChild();
        if(firstOperationChild == null) {
          operation.appendChild(soapOperation);
        }
        else {
          operation.insertBefore(soapOperation, firstOperationChild);
        }
          
        NodeList inputs = 
        	domBindingElement.getElementsByTagNameNS(
        			"http://schemas.xmlsoap.org/wsdl/", "input");
        int numInputs = inputs.getLength();
        for(int j = 0; j < numInputs; j++) {
          Element input = (Element)inputs.item(i);
        	  
          Element soapBody = 
        	  doc.createElementNS("http://eclipsewtp.org/wsdl/soap/", 
        			              "wtpsoap:body");
          soapBody.setAttribute("use", "literal");
              
          Node firstInputChild = input.getFirstChild();
          if(firstInputChild == null) {
            input.appendChild(soapBody);
          }
          else {
            input.insertBefore(soapBody, firstInputChild);
          }
        }
          
        NodeList outputs = 
        	domBindingElement.getElementsByTagNameNS(
        			"http://schemas.xmlsoap.org/wsdl/", "output");
        int numOutputs = outputs.getLength();
        for(int j = 0; j < numOutputs; j++) {
          Element output = (Element)outputs.item(i);
        	  
          Element soapBody = 
        	  doc.createElementNS("http://eclipsewtp.org/wsdl/soap/",
        				          "wtpsoap:body");
          soapBody.setAttribute("use", "literal");
              
          Node firstOutputChild = output.getFirstChild();
          if(firstOutputChild == null) {
            output.appendChild(soapBody);
          }
          else {
            output.insertBefore(soapBody, firstOutputChild);
          }
        }
      }
    }
  }
  
  public void selectionChanged(IAction action, ISelection selection) {
    if(selection instanceof StructuredSelection) {
      this.selection = (StructuredSelection)selection;
    }
  }
}
