/******************************************************************************* 
 * Copyright (c) 2005, 2007 Naci Dai, Lawrence Mandel, and Arthur Ryman. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * 
 * This sample developed for the book 
 *     Eclipse Web Tools Platform: Developing Java Web Applications
 * See http://eclipsewtp.org 
 *******************************************************************************/ 
package com.leagueplanet.systemtest;

import junit.framework.TestCase;

import com.meterware.httpunit.TableCell;
import com.meterware.httpunit.WebConversation;
import com.meterware.httpunit.WebForm;
import com.meterware.httpunit.WebLink;
import com.meterware.httpunit.WebResponse;
import com.meterware.httpunit.WebTable;

public class UpdateScoreTest extends TestCase {

  public void testUpdateScore() {
    try {
      WebConversation wc = new WebConversation();

      // Pobranie strony terminarza.
      WebResponse resp = wc
      .getResponse("http://localhost:8080/IceHockeyServiceClient/" + 
    		       "schedule?scheduleId=1");

      // Wyuskanie tabeli terminarza.
      WebTable scheduleTable = resp.getTables()[0];
      // Wyuskanie kolumny wynikw.
      int numCols = scheduleTable.getColumnCount();
      int scoreCol = -1;
      for (int i = 0; i < numCols; i++) {
        if ("Wynik".equals(scheduleTable.getTableCell(0, i).getText())) {
          scoreCol = i;
          break;
        }
      }
      // Wyuskanie i "kliknicie" odnonika aktualizacji wyniku pierwszego meczu.
      TableCell firstGameLinkCol = 
    	  scheduleTable.getTableCell(1, scoreCol);
      String score = firstGameLinkCol.getText();
      WebLink editFirstGameLink = firstGameLinkCol.getLinks()[0];
      WebResponse editResp = editFirstGameLink.click();

      // Sprawdzenie, czy w odpowiedzi otrzymano stron aktualizacji wyniku.
      assertEquals("Wybranie odnonika edycji wyniku nie doprowadzio do zwrcenia " +
    		       "strony potwierdzenia.",
				   "Wprowadzanie wyniku", editResp.getTitle());

      // Odwrcenie wyniku.
      WebForm editForm = editResp.getFormWithName("enterScore");
      String visitorScore = editForm.getParameterValue("visitorScore");
      String homeScore = editForm.getParameterValue("homeScore");
      editForm.setParameter("visitorScore", homeScore);
      editForm.setParameter("homeScore", visitorScore);
      WebResponse submitResp = editForm.submit();

      // Sprawdzenie, czy pojawia si strona potwierdzenia.
      assertEquals("Wybranie odnonika edycji wyniku nie doprowadzio do zwrcenia " +
    		       "strony potwierdzenia.",
				   "Potwierdzenie", submitResp.getTitle());

      // Wyuskanie odnonika powrotnego do strony terminarza.
      WebLink scheduleLink = submitResp.getLinkWith("Sezon 2006-2007");
      WebResponse scheduleResp = scheduleLink.click();

      // Sprawdzenie, czy pojawia si strona terminarza.
      assertTrue("Wywoanie odnonika do strony terminarza nie doprowadzio do zwrcenia " +
    		     "strony z terminarzem ligowym ",
			     scheduleResp.getTitle()
			     .startsWith("Modzieowa dziewczca liga hokejowa"));
      assertTrue("Wywoanie odnonika do strony terminarza nie doprowadzio do zwrcenia " +
    		     "strony z terminarzem ligowym ",
			     scheduleResp.getTitle()
			     .endsWith("Sezon 2006-2007"));

      // Sprawdzenie, czy wynik zosta faktycznie zaktualizowany.
      WebTable updatedScheduleTable = scheduleResp.getTables()[0];
      TableCell updatedFirstGameLinkCol = updatedScheduleTable
                                          .getTableCell(1, scoreCol);
      String updatedScore = updatedFirstGameLinkCol.getText();
      int scoreDiv = score.indexOf("-");
      String reverseScore = score.substring(scoreDiv + 1) + "-" 
                            + score.substring(0,scoreDiv);
      assertEquals("Wynik nie zosta poprawnie ustawiony.", reverseScore, 
    		       updatedScore);
      } catch (Exception e) {
        fail("Scenariusz testowy zakoczy si niepowodzeniem. Powd: " + e);
    }
  }
}
