/******************************************************************************* 
 * Copyright (c) 2005, 2007 Naci Dai, Lawrence Mandel, and Arthur Ryman. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * 
 * This sample developed for the book 
 *     Eclipse Web Tools Platform: Developing Java Web Applications
 * See http://eclipsewtp.org 
 *******************************************************************************/ 
package com.leagueplanet.mdb;

import javax.jms.JMSException;
import javax.jms.ObjectMessage;

import com.leagueplanet.model.League;
import com.leagueplanet.services.IceHockeyFacade;
import com.leagueplanet.services.LeagueFacade;

/**
 * @ejb.bean 
 *       name="AsyncLeagueFacade" 
 *       acknowledge-mode="Auto-acknowledge"
 *       destination-type="javax.jms.Queue" 
 *       transaction-type="Container"
 *       destination-jndi-name="queue/AsyncLeagueFacade"
 *       connection-factory-jndi-name="ConnectionFactory"
 * 
 * @ejb.transaction="Supports"
 */

public class AsyncLeagueFacadeBean implements
		javax.ejb.MessageDrivenBean,
		javax.jms.MessageListener {

	private javax.ejb.MessageDrivenContext messageContext = null;
	private LeagueFacade leagueFacade;

	public void setMessageDrivenContext(
			javax.ejb.MessageDrivenContext messageContext)
			throws javax.ejb.EJBException {
		this.messageContext = messageContext;
	}

	/**
	 * @ejb.create-method
	 */
	public void ejbCreate() {
		leagueFacade = IceHockeyFacade.getLeagueFacade();
	}

	public void ejbRemove() {
		messageContext = null;
	}

	public void onMessage(javax.jms.Message message) {
		try {
			League aNewLeague = (League) ((ObjectMessage) message)
					.getObject();
			leagueFacade.createLeague(aNewLeague);
			System.out.println("New League:"
					+ aNewLeague.getName());
		} catch (JMSException e) {
			e.printStackTrace();
		}
	}
}
