<!--
/******************************************************************************* 
 * Copyright (c) 2005, 2007 Naci Dai, Lawrence Mandel, and Arthur Ryman. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * 
 * This sample developed for the book 
 *     Eclipse Web Tools Platform: Developing Java Web Applications
 * See http://eclipsewtp.org 
 *******************************************************************************/ 
-->
<%@ page language="java" contentType="text/html; charset=ISO-8859-2"
	pageEncoding="ISO-8859-2"%>

<%@page import="com.leagueplanet.ejb.LeagueFacade"%>
<%@page import="com.leagueplanet.ejb.LeagueFacadeUtil"%>
<%@page import="com.leagueplanet.model.League"%>
<%@page import="com.leagueplanet.model.Schedule"%>
<%@page import="com.leagueplanet.model.Game"%>
<%@page import="java.util.Iterator"%>
<%@page import="java.text.SimpleDateFormat"%>
<html>
<%
			LeagueFacade leagueFacade = LeagueFacadeUtil
			.getHome().create();
	League league = leagueFacade.findLeague(1);
	Iterator schedules = league.getSchedules()
			.iterator();
%>
<head>
<title><%=league.getName()%></title>
<link rel="stylesheet" href="schedule.css" type="text/css" />
</head>
<body>
<h1><%=league.getName()%></h1>
<% 	
while(schedules.hasNext()){
Schedule schedule = (Schedule)schedules.next();
 %>
<h2><%=schedule.getName()%></h2>
<br />

<table>
	<thead>
		<tr>
			<th>Godzina</th>
			<th>Arena</th>
			<th>Gospodarze</th>
			<th>Gocie</th>
			<th>Wynik</th>
		</tr>
	</thead>
	<tbody>
<% Iterator events = schedule.getEvents().iterator();
	int i = 0;
	while (events.hasNext()) {
		i++;
		Game game = (Game) events.next();
		SimpleDateFormat dateFormat = new SimpleDateFormat(
		"d MMM yyyy - HH:mm ");
%>
		<tr class="<%= (i%2 == 0 ? "even-row" :"odd-row") %>">
			<td><%=dateFormat.format(game.getDateAndTime()
										.getTime())%></td>
			<td><%=game.getLocation().getName()%></td>
			<td><%=game.getHome().getName()%></td>
			<td><%=game.getVisitor().getName()%></td>
			<td><%=game.getScore().getHome()%>- 
			    <%=game.getScore().getVisitor()%></td>
		</tr>
<%
}
%>
	</tbody>
</table>
<%} %>
</body>
</html>

