/******************************************************************************* 
 * Copyright (c) 2005, 2007 Naci Dai, Lawrence Mandel, and Arthur Ryman. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * 
 * This sample developed for the book 
 *     Eclipse Web Tools Platform: Developing Java Web Applications
 * See http://eclipsewtp.org 
 *******************************************************************************/ 
package org.eclipsewtp.resourceresolution;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.wst.common.uriresolver.internal.provisional
                                                  .URIResolverExtension;

public class FolderUriResolver implements URIResolverExtension 
{
  private static String folderLoc = "C:/schemas/";

  public String resolve(IFile file, String baselocation, 
                        String publicId, String systemId)
  {
    String result = null;
    if(systemId != null)
    {
      String filename = systemId.replace("\\", "/");
      int lastSlashLoc = systemId.lastIndexOf('/');
      if(lastSlashLoc != -1)
      {
        filename = filename.substring(lastSlashLoc+1);
      }
      filename = folderLoc + filename;
      File localFile = new File(filename);
      if(localFile.exists())
      {
        result = "file:///" + filename;
      }
    }
    return result;
  }
}