/******************************************************************************* 
 * Copyright (c) 2005, 2007 Naci Dai, Lawrence Mandel, and Arthur Ryman. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * 
 * This sample developed for the book 
 *     Eclipse Web Tools Platform: Developing Java Web Applications
 * See http://eclipsewtp.org 
 *******************************************************************************/ 
package org.eclipsewtp.wsdlextensions;

import org.apache.xerces.dom.ElementImpl;
import org.eclipse.wst.wsdl.validation.internal.IValidationInfo;
import org.eclipse.wst.wsdl.validation.internal.IWSDLValidator;
import org.eclipse.wst.wsdl.validation.internal.exception.ValidateWSDLException;
import org.eclipse.wst.wsdl.validation.internal.xml.ElementLocation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class NamingConventionValidator implements IWSDLValidator {
  public void validate(Document domModel, IValidationInfo valInfo)
			throws ValidateWSDLException {
    Element rootElem = domModel.getDocumentElement();
    checkNames(rootElem, valInfo);
  }

  private void checkNames(Element element, IValidationInfo valInfo) {
    String name = element.getAttribute("name");
    if(name != null && name.length() > 0 && 
       !Character.isUpperCase(name.charAt(0))) {
      ElementLocation loc = (ElementLocation)((ElementImpl)element)
      	.getUserData();
      valInfo.addError("Nazwa elementu musi zaczyna si od " + 
    		  "wielkiej litery.", loc.getLineNumber(),
    		  loc.getColumnNumber(), valInfo.getFileURI());
    }
		
    NodeList childNodes = element.getChildNodes();
    int numChildNodes = childNodes.getLength();
    for(int i = 0; i < numChildNodes; i++) {
      Node child = childNodes.item(i);
      if(child instanceof Element) {
        checkNames((Element)child, valInfo);
      }
    }
  }
}
