/******************************************************************************* 
 * Copyright (c) 2005, 2007 Naci Dai, Lawrence Mandel, and Arthur Ryman. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * 
 * This sample developed for the book 
 *     Eclipse Web Tools Platform: Developing Java Web Applications
 * See http://eclipsewtp.org 
 *******************************************************************************/ 
package org.eclipsewtp.wsdlextensions;

import org.eclipse.wst.wsdl.ui.internal.filter
                                       .ExtensiblityElementFilter;
import org.w3c.dom.Element;

public class SOAPExtensibilityElementFilter 
    implements ExtensiblityElementFilter {
  private static final String WSDL_NAMESPACE 
      = "http://schemas.xmlsoap.org/wsdl/";
  private static final String WTP_SOAP_NAMESPACE
      = "http://eclipsewtp.org/wsdl/soap/";
	
  public boolean isValidContext(Element parentElement, 
		  String localName) {
    String parentElementName = parentElement.getLocalName();
    String parentElementNamespace = parentElement.getNamespaceURI();
    if(WSDL_NAMESPACE.equals(parentElementNamespace)) {
      if("port".equals(parentElementName)) {
        return "address".equals(localName);
      }
      else if("binding".equals(parentElementName)) {
        return "binding".equals(localName);
      }
      else if("binding".equals(parentElement.getParentNode()
    		  .getLocalName())) {
        if("operation".equals(parentElementName)) { 
          return "operation".equals(localName);
        }
      }
      else if("operation".equals(parentElement.getParentNode()
    		  .getLocalName())) {
        if("binding".equals(parentElement.getParentNode()
            .getParentNode().getLocalName())) {
          if("input".equals(parentElementName)) {
            return "body".equals(localName) || 
                   "header".equals(localName);
          }
          else if("output".equals(parentElementName)) {
            return "body".equals(localName) || 
                   "header".equals(localName);
          }
          else if("fault".equals(parentElementName)) {
            return "fault".equals(localName);
          }
        }
      }
    }
    else if(WTP_SOAP_NAMESPACE.equals(parentElementNamespace)) {
      if("header".equals(parentElementName)) {
        return "headerfault".equals(localName);
      }
    }
    return false;
  }
}