/******************************************************************************* 
 * Copyright (c) 2005, 2007 Naci Dai, Lawrence Mandel, and Arthur Ryman. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * 
 * This sample developed for the book 
 *     Eclipse Web Tools Platform: Developing Java Web Applications
 * See http://eclipsewtp.org 
 *******************************************************************************/ 
package com.leagueplanet;

import junit.framework.TestCase;

public class UserTest extends TestCase {
  private User user;
  protected void setUp() throws Exception {
    user = new User();
  }

  protected void tearDown() throws Exception {
    user = null;
  }

  public void testLogInTypical() {
    user.logIn("userid");
    assertTrue("Uytkownik nie jest zalogowany.", user.isLoggedIn());
    assertNotNull("Identyfikator uytkownika po zalogowaniu jest pusty.", 
    		      user.getUserId());
  }
	
  public void testLogInEmpty() {
    user.logIn("");
    assertTrue("Uytkownik nie jest zalogowany.", user.isLoggedIn());
    assertNotNull("Identyfikator uytkownika po zalogowaniu jest pusty.", 
    		      user.getUserId());
  }
	
  public void testLogInNull() {
    user.logIn(null);
    assertTrue("Uytkownik nie jest zalogowany.", user.isLoggedIn());
    assertNotNull("Identyfikator uytkownika po zalogowaniu jest pusty.", 
                  user.getUserId());
  }

  public void testLogOut() {
    user.logIn("userid");
    user.logOut();
    assertFalse("Uytkownik jest zalogowany po wylogowaniu.", 
    		    user.isLoggedIn());
    assertEquals("Identyfikator uytkownika nie jest cigiem pustym.", "", 
                 user.getUserId());
  }
}
